% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_sky_pixels.R
\name{find_sky_pixels}
\alias{find_sky_pixels}
\title{Find sky pixels}
\usage{
find_sky_pixels(r, z, a, sample_size_pct = 30)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{z}{\linkS4class{SpatRaster} built with \code{\link{zenith_image}}.}

\item{a}{\linkS4class{SpatRaster} built with \code{\link{azimuth_image}}.}

\item{sample_size_pct}{Numeric vector of length one. Minimum percentage of
cells to sample. The population is comprised of 1296 cells of \eqn{5 \times
5} degrees.}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and
  \code{1}. This layer masks pixels that are very likely pure sky pixels.
}
\description{
Find sky pixels automatically.
}
\details{
This function assumes that:

\itemize{

\item there is at least one pure sky pixel at the level of cells of \eqn{30
\times 30} degrees, and

\item sky pixels have a digital number (DN) greater than canopy pixels have.

}


For each \eqn{30 \times 30} cell, this method computes a quantile value and
uses it as a threshold to select the pure sky pixels from the given cell. As
a result, a binarized image is produced in a regional binarization fashion
(\code{\link{regional_thresholding}}). This process starts with a quantile
probability of 0.99. After producing the binarized image, this function uses
a search grid with cells of \eqn{5 \times 5} degrees to count how many of
these cells have at least one sky pixel (pixels equal to one in the binarized
image). If the percentage of  cells with sky pixels does not reach argument
\code{sample_size_pct}, it goes back to the binarization step but decreasing
the probability by 0.01 points.

If probability reach 0.9 and the \code{sample_size_pct} criterion were not
yet satisfied, the \code{sample_size_pct} is decreased one percent and the
process starts all over again.
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
caim <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
z <- zenith_image(ncol(caim), lens("Nikon_FCE9"))
a <- azimuth_image(z)
r <- gbc(caim$Blue)
bin <- find_sky_pixels(r, z, a)
plot(bin)
}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{obia}()},
\code{\link{ootb_mblt}()},
\code{\link{ootb_obia}()},
\code{\link{regional_thresholding}()},
\code{\link{thr_image}()},
\code{\link{thr_isodata}()}
}
\concept{Binarization Functions}
