% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BtcAddresses.R
\name{PrivKey2Wif}
\alias{PrivKey2Wif}
\title{Create WIF from a private key}
\usage{
PrivKey2Wif(privkey, mainnet = TRUE)
}
\arguments{
\item{privkey}{\code{character}, a private key.}

\item{mainnet}{\code{logical}, whether the WIF should correspond
to the mainnet or testnet.}
}
\value{
\code{character}, the WIF key
}
\description{
Returns the corresponding WIF key from a private key
}
\examples{
pk <- createPrivateKey()
PrivKey2Wif(pk)
}
\references{
\url{https://en.bitcoin.it/wiki/Wallet_import_format},\cr
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BtcAdresses: \code{\link{BTCADR-class}},
  \code{\link{PrivKey2PubKey}},
  \code{\link{PubHash2BtcAdr}},
  \code{\link{PubKey2PubHash}}, \code{\link{Wif2PrivKey}},
  \code{\link{base58CheckDecode}},
  \code{\link{base58CheckEncode}}, \code{\link{concatHex}},
  \code{\link{createBtcAdr}},
  \code{\link{createPrivateKey}}, \code{\link{decodeHex}},
  \code{\link{hash160}}, \code{\link{hash256}},
  \code{\link{validBtcAdr}}
}
\author{
Bernhard Pfaff
}
\concept{BtcAdresses}
