% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.cv.bridge}
\alias{predict.cv.bridge}
\title{Make predictions from a 'cv.bridge' object}
\usage{
\method{predict}{cv.bridge}(object, newx, s = c("lambda.min",
  "lambda.1se"), type = c("response", "nonzero", "coefficients"), ...)
}
\arguments{
\item{object}{A 'cv.bridge' object.}

\item{newx}{Matrix of new values for x at which predictions are to be made.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are required.}

\item{type}{It should one of "response", "nonzero" or "coefficients". The "response" is for predicted values, the "nonzero" is for exacting non-zero coefficients and the "coefficients" is for the estimated coefficients.}

\item{...}{Additional arguments for compatibility.}
}
\value{
Among a matrix with predictions, a vector non-zero indexing or a vector of coefficients
}
\description{
Makes predictions from a cross-validated 'cv.bridge' model
}
\examples{
set.seed(2019) 
beta <- c(3, 1.5, 0, 0, 2, 0, 0, 0)
p <- length(beta)
beta <- matrix(beta, nrow = p, ncol = 1)

n = 100
X = matrix(rnorm(n*p),n,p)
y = X\%*\%beta + rnorm(n) 

model1 <- cv.bridge(X, y, q = 1)
coef(model1,s='lambda.min')
predict(model1,newx=X[1:5,], s="lambda.min", type="response")
predict(model1, s="lambda.min",type="coefficient")
}
\seealso{
\code{\link{coef.cv.bridge}}
}
\author{
Bahadir Yuzbasi, Mohammad Arashi and Fikri Akdeniz \cr Maintainer: Bahadir Yuzbasi \email{b.yzb@hotmail.com}
}
