% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_query}
\alias{rba_reactome_query}
\title{Query and Retrieve any Reactome knowledge-base Object}
\usage{
rba_reactome_query(
  ids,
  enhanced = FALSE,
  map = FALSE,
  attribute_name = NULL,
  ...
)
}
\arguments{
\item{ids}{A single or Multiple database IDs (DbId), Stable IDs (StId) or
a mixture of both.}

\item{enhanced}{Logical: (Default = FALSE) If 'TRUE' more information on
the supplied entry will be returned. (You can set this argument to 'TRUE'
Only when you supply a single ID).}

\item{map}{(Default = FALSE) Should the supplied IDs be mapped? This
  argument will only be considered when you supply multiple IDs.
(e.g. when you supply previous version of stable identifiers.)}

\item{attribute_name}{(Optional) Only Return an Attribute of the supplied
Database Object. (You can use this argument Only when you
supply a single ID)}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
List containing your query outputs.
}
\description{
Using this Comprehensive function, You can Retrieve any object from
  \href{https://reactome.org/content/schema/DatabaseObject/}{Reactome
  knowledge-base}
}
\section{Corresponding API Resources}{

 "POST https://reactome.org/ContentService/data/query/ids"
 \cr "POST https://reactome.org/ContentService/data/query/ids/map"
 \cr "GET https://reactome.org/ContentService/data/query/\{id\}"
 \cr "GET https://reactome.org/ContentService/data/query/enhanced/\{id\}"
 \cr "GET https://reactome.org/ContentService/data/query/\{id\}/\{attributeName\}"
}

\examples{
\donttest{
rba_reactome_query(ids = c("8953958", "11982506", "R-ALL-9649879"))
}
\donttest{
rba_reactome_query(ids = "R-HSA-9656256", enhanced = TRUE)
}
\donttest{
rba_reactome_query(ids = "8863054", attribute_name = "displayName")
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\concept{"Reactome Content Service - Common Data Retrieval"}
