% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{libbi_run}
\alias{libbi_run}
\title{Using the LibBi wrapper to launch LibBi}
\arguments{
\item{options}{list of additional arguments to pass to the call to \code{libbi}}

\item{add_options}{deprecated, replaced by \code{options}}

\item{log_file_name}{path to a file to text file to report the output of \code{libbi}}

\item{init}{initialisation of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as input)}

\item{input}{input of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as input)}

\item{obs}{observations of the model, either supplied as a list of values and/or data frames, or a (netcdf) file name, or a \code{\link{libbi}} object which has been run (in which case the output of that run is used as observations)}

\item{time_dim}{The time dimension in any R objects that have been passed (\code{init}, \code{input}) and \code{obs}); if not given, will be guessed}

\item{...}{any unrecognised options will be added to \code{options}}
}
\description{
The method \code{run} of an instance of \code{\link{libbi}}
allows to launch \code{libbi} with a particular set of command line
arguments.
}
\examples{
bi_object <- libbi$new(client = "sample",
                       model = system.file(package="rbi", "PZ.bi"),
                       options = list(sampler = "smc2"))
\dontrun{bi_object$run(options=list(nthreads = 1), verbose = TRUE)}
if (bi_object$run_flag) {
  bi_file_summary(bi_object$output_file_name)
}
}
\seealso{
\code{\link{libbi}}
}

