% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libbi.R
\name{libbi}
\alias{libbi}
\title{LibBi Wrapper}
\arguments{
\item{client}{is either "draw", "filter", "sample"... see LibBi documentation.}

\item{model}{either a character vector giving the path to a model file (typically ending in ".bi"), or a \code{bi_model} object}

\item{config}{path to a configuration file, containing multiple arguments}

\item{global_options}{additional arguments to pass to the call to \code{libbi}, on top of the ones in the config file}

\item{working_folder}{path to a folder from which to run \code{libbi}; default to a temporary folder.}

\item{path_to_libbi}{path to \code{libbi} binary; by default it tries to locate \code{libbi}}

\item{input}{input file (given as file name or \code{libbi} object or a list of data frames}

\item{init}{init file (given as file name or \code{libbi} object or a list of data frames}

\item{obs}{observation file (given as file name or \code{libbi} object or a list of data frames}

\item{run}{(boolean) whether to run the model
using the \code{which} Unix command, after having loaded "~/.bashrc" if present;
if unsuccessful it tries "~/PathToBiBin/libbi"; if unsuccessful again it fails.}
}
\description{
\code{libbi} allows to call \code{libbi}.
Upon creating a new libbi object, the following arguments can be given.
Once the instance is created, \code{libbi} can be run through the \code{run}
method documented in \code{\link{libbi_run}}. Note that \code{\link{libbi}} objects can be plotted using \code{\link{plot}} if the \code{rbi.helpers} package is loaded.
}
\examples{
bi_object <- libbi$new(client = "sample",
                       model = system.file(package="rbi", "PZ.bi"),
                       global_options = list(sampler = "smc2"))
}
\seealso{
\code{\link{libbi_run}}, \code{\link{libbi_clone}}
}

