% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_market_expectations.R
\name{get_annual_market_expectations}
\alias{get_annual_market_expectations}
\title{Get annual market expectations of economic indicators}
\usage{
get_annual_market_expectations(indic, start_date = NULL, end_date = NULL,
  ...)
}
\arguments{
\item{indic}{a character vector with economic indicators names: Balança Comercial,
Balanço de Pagamentos, Fiscal, IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe,
Preços administrados por contrato e monitorados, Produção industrial, PIB Agropecuária,
PIB Industrial, PIB Serviços, PIB Total, Meta para taxa over-selic, Taxa de câmbio.
They are case sensitive and don't forget the accents.}

\item{start_date}{series initial date. Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date. Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

\code{indic} argumento must be one of these: Balança Comercial,
Balanço de Pagamentos, Fiscal, IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe,
Preços administrados por contrato e monitorados, Produção industrial, PIB Agropecuária,
PIB Industrial, PIB Serviços, PIB Total, Meta para taxa over-selic, Taxa de câmbio.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the following ten columns: \code{date}, \code{indic},
\code{indic_detail}, \code{reference_year}, \code{mean}, \code{median}, \code{sd},
\code{coefvar}, \code{min}, \code{max}.
}
\description{
Statistics for the annual expectations of economic indicators: mean, median, standard
deviate, minimum, maximum and the coefficient of variation.
All statistics are computed based on annual expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
There are annual expectations available for the following indicators: Balança Comercial,
Balanço de Pagamentos, Fiscal, IGP-DI, IGP-M, INPC, IPA-DI, IPA-M, IPCA, IPCA-15, IPC-Fipe,
Preços administrados por contrato e monitorados, Produção industrial, PIB Agropecuária,
PIB Industrial, PIB Serviços, PIB Total, Meta para taxa over-selic, Taxa de câmbio.
}
\examples{
indic <- c("Balanço de Pagamentos", "Fiscal")
end_date <- "2018-01-31"
x <- get_annual_market_expectations(indic, end_date = end_date, `$top` = 10)

}
