% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get.R, R/sgs.R
\name{rbcb_get}
\alias{rbcb_get}
\alias{rbcb_get.sgs}
\title{Gets data from BCB open data services}
\usage{
rbcb_get(x, ...)

\method{rbcb_get}{sgs}(x, from = NULL, to = NULL, last = 0, ...)
}
\arguments{
\item{x}{an object that represents the kind of data to be downloaded}

\item{...}{others arguments}

\item{from}{series initial date. Accepts ISO character formated date and
\code{Date}.}

\item{to}{series final date. Accepts ISO character formated date and
\code{Date}.}

\item{last}{last items of the series

To use the SGS API a `sgs` object should be passed.}
}
\value{
a dataset with the corresponding data (usually a `tibble`)
}
\description{
Gets SGS, currency, market expectations and many other datasets
from the Brazilian Central Bank open data services.
}
\examples{
\dontrun{
x <- sgs(USD = 1, SELIC = 1178)
rbcb_get(x, from = Sys.Date() - 10)
}
}
