% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agedepth.R
\name{agedepth}
\alias{agedepth}
\title{Plot an age-depth model}
\usage{
agedepth(
  set = get("info"),
  BCAD = set$BCAD,
  depth.unit = set$depth.unit,
  age.unit = "yr",
  unit = depth.unit,
  d.lab = c(),
  age.lab = c(),
  yr.lab = age.lab,
  kcal = FALSE,
  acc.lab = c(),
  d.min = c(),
  d.max = c(),
  d.by = c(),
  depths = set$depths,
  depths.file = FALSE,
  age.min = c(),
  yr.min = age.min,
  age.max = c(),
  yr.max = age.max,
  hiatus.option = 1,
  dark = c(),
  prob = set$prob,
  rounded = c(),
  d.res = 400,
  age.res = 400,
  yr.res = age.res,
  date.res = 100,
  rotate.axes = FALSE,
  rev.age = FALSE,
  rev.yr = rev.age,
  rev.d = FALSE,
  maxcalc = 500,
  height = 1,
  calheight = 1,
  mirror = TRUE,
  up = TRUE,
  cutoff = 0.1,
  plot.range = TRUE,
  range.col = grey(0.5),
  range.lty = "12",
  mn.col = "red",
  mn.lty = "12",
  med.col = NA,
  med.lty = "12",
  C14.col = rgb(0, 0, 1, 0.35),
  C14.border = rgb(0, 0, 1, 0.5),
  cal.col = rgb(0, 0.5, 0.5, 0.35),
  cal.border = rgb(0, 0.5, 0.5, 0.5),
  dates.col = c(),
  pb.background = 0.5,
  pbmodelled.col = function(x) rgb(0, 0, 1, 0.5 * x),
  pbmeasured.col = "blue",
  pb.lim = c(),
  supp.col = "purple",
  plot.tail = TRUE,
  remove.tail = TRUE,
  MCMC.resample = TRUE,
  hiatus.col = grey(0.5),
  hiatus.lty = "12",
  rgb.scale = c(0, 0, 0),
  rgb.res = 100,
  slump.col = grey(0.8),
  normalise.dists = TRUE,
  same.heights = FALSE,
  cc = set$cc,
  title = set$core,
  title.location = "topleft",
  title.size = 1.5,
  plot.labels = FALSE,
  labels = c(),
  label.age = 1,
  label.size = 0.8,
  label.col = "black",
  label.offset = c(0, 0),
  label.adj = c(0.5, 0),
  label.rot = 0,
  after = set$after,
  bty = "l",
  mar.left = c(3, 3, 1, 0.5),
  mar.middle = c(3, 0, 1, 0.5),
  mar.right = c(3, 0, 1, 0.5),
  mar.main = c(3, 3, 1, 1),
  righthand = 3,
  mgp = c(1.7, 0.7, 0),
  xaxs = "r",
  yaxs = "i",
  prior.ticks = "n",
  prior.fontsize = 0.9,
  toppanel.fontsize = 0.9,
  xaxt = "s",
  yaxt = "s",
  plot.pb = TRUE,
  pb.lty = 1,
  plot.pdf = FALSE,
  dates.only = FALSE,
  model.only = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{depth.unit}{Units of the depths. Defaults to the one provided in the Bacon() command, \code{depth.unit=set$depth.unit}.}

\item{age.unit}{Units of the ages. Defaults to \code{age.unit="yr"}.}

\item{unit}{Deprecated and replaced by \code{depth.unit}.}

\item{d.lab}{The labels for the depth axis. Default \code{d.lab="Depth (cm)"}. See also \code{depth.unit}.}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{kcal}{Use kcal BP. Default is \code{kcal=FALSE}.}

\item{acc.lab}{The labels for the accumulation rate plot (top middle). Default \code{d.lab="Acc. rate (yr/cm)"} (or whatever units you're using).}

\item{d.min}{Minimum depth of age-depth model (use this to extrapolate to depths higher than the top dated depth).}

\item{d.max}{Maximum depth of age-depth model (use this to extrapolate to depths below the bottom dated depth).}

\item{d.by}{Depth intervals at which ages are calculated. Default 1. Alternative depth intervals can be provided using, e.g., d.\code{d.by=0.5}.}

\item{depths}{By default, Bacon will calculate the ages for the depths \code{d.min} to \code{d.max} in steps of \code{d.by}. Alternative depths can be provided as, e.g., \code{depths=seq(0, 100, length=500)} or as a file, e.g., \code{depths=read.table("CoreDepths.txt"}. See also \code{depths.file}.}

\item{depths.file}{By default, Bacon will calculate the ages for the depths \code{d.min} to \code{d.max} in steps of \code{d.by}.
If \code{depths.file=TRUE}, Bacon will read a file containing the depths for which you require ages.
This file, containing the depths in a single column without a header, should be stored within \code{coredir},
and its name should start with the core's name and end with '_depths.txt'. Then specify \code{depths.file=TRUE} (default \code{FALSE}). See also \code{depths}.}

\item{age.min}{Minimum age of the age-depth plot.}

\item{yr.min}{Deprecated - use age.min instead.}

\item{age.max}{Maximum age of the age-depth plot.}

\item{yr.max}{Deprecated - use age.min instead.}

\item{hiatus.option}{How to calculate accumulation rates and ages for sections with hiatuses. Either extrapolate from surrounding sections (default, \code{hiatus.option=1}), use a w-weighted mix between the prior and posterior values for depths below the hiatus and prior information only for above the hiatus (\code{hiatus.option=2}), or use the originally calculated slopes (\code{hiatus.option=0}).}

\item{dark}{Darkness of the greyscale age-depth model. By default, the darkest grey value is calculated as 10 times the height of the lowest-precision age estimate \code{dark=c()}. Lower values will result in lighter grey but values >1 are not allowed.}

\item{prob}{Confidence interval to report (between 0 and 1, default 0.95 or 95\%).}

\item{rounded}{Rounding of years. Default is to round to single years (1 digit for plum models).}

\item{d.res}{Resolution or amount of greyscale pixels to cover the depth scale of the age-model plot. Default \code{d.res=200}.}

\item{age.res}{Resolution or amount of greyscale pixels to cover the age scale of the age-model plot. Default \code{yr.res=200}.}

\item{yr.res}{Deprecated - use age.res instead.}

\item{date.res}{Date distributions are plotted using \code{date.res=100} points by default.}

\item{rotate.axes}{By default, the age-depth model is plotted with the depths on the horizontal axis and ages on the vertical axis. This can be changed with \code{rotate.axes=TRUE}.}

\item{rev.age}{The direction of the age axis, which can be reversed using \code{rev.age=TRUE}.}

\item{rev.yr}{Deprecated - use rev.age instead.}

\item{rev.d}{The direction of the depth axis, which can be reversed using \code{rev.d=TRUE}.}

\item{maxcalc}{Number of depths to calculate ages for. If this is more than \code{maxcalc=500}, a warning will be shown that calculations will take time.}

\item{height}{The maximum heights of the distributions of the dates on the plot. See also \code{normalise.dists}.}

\item{calheight}{Multiplier for the heights of the distributions of dates on the calendar scale. Defaults to \code{calheight=1}.}

\item{mirror}{Plot the dates as 'blobs'. Set to \code{mirror=FALSE} to plot simple distributions.}

\item{up}{Directions of distributions if they are plotted non-mirrored. Default \code{up=TRUE}.}

\item{cutoff}{Avoid plotting very low probabilities of date distributions (default \code{cutoff=0.1}).}

\item{plot.range}{Whether or not to plot the curves showing the confidence ranges of the age-model. Defaults to (\code{plot.range=TRUE}).}

\item{range.col}{The colour of the curves showing the confidence ranges of the age-model. Defaults to medium grey (\code{range.col=grey(0.5)}).}

\item{range.lty}{The line type of the curves showing the confidence ranges of the age-model. Defaults to \code{range.lty=12}.}

\item{mn.col}{The colour of the mean age-depth model: default \code{mn.col="red"}.}

\item{mn.lty}{The line type of the mean age-depth model. Default \code{mn.lty=12}.}

\item{med.col}{The colour of the median age-depth model: not drawn by default \code{med.col=NA}.}

\item{med.lty}{The line type of the median age-depth model. Default \code{med.lty=12}.}

\item{C14.col}{The colour of the calibrated ranges of the dates. Default is semi-transparent blue: \code{C14.col=rgb(0,0,1,.35)}.}

\item{C14.border}{The colours of the borders of calibrated 14C dates. Default is semi-transparent dark blue: \code{C14.border=rgb(0, 0, 1, 0.5)}.}

\item{cal.col}{The colour of the non-14C dates. Default is semi-transparent blue-green: \code{cal.col=rgb(0,.5,.5,.35)}.}

\item{cal.border}{The colour of the border of non-14C dates in the age-depth plot: default semi-transparent dark blue-green: \code{cal.border=rgb(0,.5,.5,.5)}. Not used by default.}

\item{dates.col}{As an alternative to colouring dates based on whether they are 14C or not, sets of dates can be coloured as, e.g., \code{dates.col=colours()[2:100]}.}

\item{pb.background}{Probability at which total Pb values are considered to have reached background values, or in other words, that their modelled values are at or below supported + detection limit (Al)). Setting this at 0.5 means that any depth with a Pb measurement, where at least half of the iterations model Pb values reaching background values, is flagged as having reached background. The age-model is not extended to any Pb measurements that have reached background.}

\item{pbmodelled.col}{Colour of the modelled 210Pb values. Defaults to shades of blue: \code{pbmodelled.col=function(x) rgb(0,0,1,x)}.}

\item{pbmeasured.col}{Colour of the measured 210Pb values (default \code{pbmeasured.col="blue"}). Draws rectangles of the upper and lower depths as well as the Pb values with 95 percent error ranges.}

\item{pb.lim}{Axis limits for the Pb-210 data. Calculated automatically by default (\code{pblim=c()}).}

\item{supp.col}{Colour of supported Pb-210. Defaults to purple, because why not.}

\item{plot.tail}{The depth axis can extend to all Pb measurements (\code{plot.tail=TRUE}), or leave out the ones where background has been reached.}

\item{remove.tail}{Whether or not to remove the tail measurements when plotting. Sometimes automated removal might go wrong, so then this option can be used to avoid removing the tail measurements. Quite similar to plot.tail.}

\item{MCMC.resample}{After the MCMC run, if there are more MCMC iterations than requested, only the last 'ssize' iterations will be retained. Defaults to TRUE.}

\item{hiatus.col}{The colour of the depths of any hiatuses. Default \code{hiatus.col=grey(0.5)}.}

\item{hiatus.lty}{The line type of the depths of any hiatuses. Default \code{hiatus.lty=12}.}

\item{rgb.scale}{The function to produce a coloured representation of all age-models. Needs 3 values for the intensity of red, green and blue. Defaults to grey-scales: \code{rgb.scale=c(0,0,0)}, but could also be, say, scales of red (\code{rgb.scale=c(1,0,0)}).}

\item{rgb.res}{Resolution of the colour spectrum depicting the age-depth model. Default \code{rgb.res=100}.}

\item{slump.col}{Colour of slumps. Defaults to \code{slump.col=grey(0.8)}.}

\item{normalise.dists}{By default, the distributions of more precise dates will cover less time and will thus peak higher than less precise dates. This can be avoided by specifying \code{normalise.dists=FALSE}.}

\item{same.heights}{Plot the distributions of the dates all at the same maximum height (default \code{same.height=FALSE}).}

\item{cc}{Calibration curve for 14C dates: \code{cc=1} for IntCal20 (northern hemisphere terrestrial), \code{cc=2} for Marine20 (marine), \code{cc=3} for SHCal20 (southern hemisphere terrestrial). For dates that are already on the cal BP scale use \code{cc=0}.}

\item{title}{The title of the age-depth model is plotted on the main panel. By default this is the core's name. To leave empty: \code{title=""}.}

\item{title.location}{Location of the title. Default \code{title.location='topleft'}.}

\item{title.size}{Size of the title font. Defaults to \code{title.size=1.5}.}

\item{plot.labels}{Whether or not to plot labels next to the dated depths. Defaults to \code{FALSE}.}

\item{labels}{Add labels to the dates (as given by the first column of the .csv file). \code{FALSE} by default.}

\item{label.age}{Position on the age axis of the date labels. By default draws them before the youngest age (1), but can also draw them after the oldest age (2), or above its mean (3).}

\item{label.size}{Size of labels.}

\item{label.col}{Colour of the labels. Defaults to the colour given to the borders of the dates.}

\item{label.offset}{Offsets of the positions of the labels, giving the x and y offsets. Defaults to c(0,0).}

\item{label.adj}{Justification of the labels. Follows R's adj option: A value of ‘0’ produces left-justified text, ‘0.5’ (the default) centered text and ‘1’ right-justified text.}

\item{label.rot}{Rotation of the label. 0 by default (horizontal).}

\item{after}{Sets a short section above and below hiatus.depths within which to calculate ages. For internal calculations - do not change.}

\item{bty}{Type of box to be drawn around plots (\code{"n"} for none, and \code{"l"} (default), \code{"7"}, \code{"c"}, \code{"u"}, or \code{"o"} for correspondingly shaped boxes).}

\item{mar.left}{Plot margins for the topleft panel (amount of white space along edges of axes 1-4). Default \code{mar.left=c(3,3,1,1)}.}

\item{mar.middle}{Plot margins for the middle panel(s) at the top (amount of white space along edges of axes 1-4). Default \code{mar.middle=c(3,3,1,1)}.}

\item{mar.right}{Plot margins for the topright panel (amount of white space along edges of axes 1-4). Default \code{mar.right=c(3,3,1,1)}.}

\item{mar.main}{Plot margins for the main panel (amount of white space along edges of axes 1-4). Default \code{mar.main=c(3,3,1,1)}.}

\item{righthand}{Adapt the righthand margins by a certain amount (default 2) to allow a righthand axis to be plotted (for plum)}

\item{mgp}{Axis text margins (where should titles, labels and tick marks be plotted). Defaults to \code{mgp=c(1.7, .7, .0)}.}

\item{xaxs}{Extension of x-axis. By default, add some extra white-space at both extremes (\code{xaxs="r"}). See ?par for other options.}

\item{yaxs}{Extension of y-axis. By default, add no extra white-space at both extremes (\code{yaxs="i"}). See ?par for other options.}

\item{prior.ticks}{Plot tickmarks and values on the vertical axes for the prior and posterior distributions. Defaults to no tick marks (\code{prior.ticks="n"}). Set to \code{prior.ticks="s"} to plot the tick marks. Note that these values are of little practical use, as they correspond poorly to, e.g., the mean and strength values. All that matters is that the areas of both the prior and the posterior distributions sum to 1; wider distributions tend to give lower peaks, and narrower distributions higher peaks.}

\item{prior.fontsize}{Font size of the prior, relative to R's standard size. Defaults to \code{prior.fontsize=0.9}.}

\item{toppanel.fontsize}{Font size of the top panels, relative to R's standard size. Defaults to \code{prior.fontsize=0.9}.}

\item{xaxt}{Whether or not to plot the x-axis. Can be used to adapt axes after a plot. See ?par for other options.}

\item{yaxt}{Whether or not to plot the y-axis. Can be used to adapt axes after a plot. See ?par for other options.}

\item{plot.pb}{Plot the 210Pb data (if present). Defaults to \code{plot.pb=TRUE}.}

\item{pb.lty}{Line type of measured Pb-210 data.}

\item{plot.pdf}{Produce a pdf file of the age-depth plot.}

\item{dates.only}{By default, the age-depth model is plotted on top of the dates. This can be avoided by supplying \code{dates.only=TRUE}.}

\item{model.only}{By default, panels showing the MCMC iterations and the priors and posteriors for accumulation rate and memory are plotted above the main age-depth model panel. This can be avoided by supplying \code{model.only=TRUE}. Note however that this removes relevant information to evaluate the age-depth model, so we do recommend to present age-models together with these upper panels.}

\item{verbose}{Provide a summary of the age ranges after producing the age-depth model graph; default \code{verbose=FALSE}.}
}
\value{
A plot of the age-depth model, and estimated ages incl. confidence ranges for each depth.
}
\description{
Plot the age-depth model of a core.
}
\details{
After loading a previous run, or after running either the \link{scissors} or \link{thinner} command, plot the age-model
again using the command \code{agedepth()}.
}
\examples{
\dontshow{
  Bacon(run=FALSE, ask=FALSE, coredir=tempfile())
  agedepth(yr.res=50, d.res=50, d.by=10)
 }
\donttest{
  Bacon(ask=FALSE, coredir=tempfile())
  agedepth()
}
}
\author{
Maarten Blaauw, J. Andres Christen
}
