% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-cotahist.R
\name{cotahist-extracts}
\alias{cotahist-extracts}
\alias{cotahist_equity_get}
\alias{cotahist_bdrs_get}
\alias{cotahist_units_get}
\alias{cotahist_etfs_get}
\alias{cotahist_fiis_get}
\alias{cotahist_fidcs_get}
\alias{cotahist_fiagros_get}
\alias{cotahist_indexes_get}
\alias{cotahist_equity_options_get}
\alias{cotahist_index_options_get}
\alias{cotahist_funds_options_get}
\alias{cotahist_get_symbols}
\title{Extract data from COTAHIST dataset}
\usage{
cotahist_equity_get(x)

cotahist_bdrs_get(x)

cotahist_units_get(x)

cotahist_etfs_get(x)

cotahist_fiis_get(x)

cotahist_fidcs_get(x)

cotahist_fiagros_get(x)

cotahist_indexes_get(x)

cotahist_equity_options_get(x)

cotahist_index_options_get(x)

cotahist_funds_options_get(x)

cotahist_get_symbols(x, symbols)
}
\arguments{
\item{x}{COTAHIST dataset returned from \code{cotahist_get}.}

\item{symbols}{list of symbols to extract market data from cotahist}
}
\value{
a data.frame with prices, volume, traded quantities informations
}
\description{
Extracts specific data from COTAHIST dataset: stocks, funds, BDRs, ETFs,
UNITs, options on stocks, options on indexes, ...
}
\examples{
\dontrun{
df <- cotahist_equity_get(x)
}
\dontrun{
df <- cotahist_brds_get(x)
}
\dontrun{
df <- cotahist_units_get(x)
}
\dontrun{
df <- cotahist_etfs_get(x)
}
\dontrun{
df <- cotahist_fiis_get(x)
}
\dontrun{
df <- cotahist_fidcs_get(x)
}
\dontrun{
df <- cotahist_fiagros_get(x)
}
\dontrun{
df <- cotahist_indexes_get(x)
}
\dontrun{
df <- cotahist_equity_options_get(x)
}
\dontrun{
df <- cotahist_index_options_get(x)
}
\dontrun{
df <- cotahist_funds_options_get(x)
}
\dontrun{
df <- cotahist_get_symbols(x, c("BBDC4", "ITSA4", "JHSF3"))
}
}
