% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lights.R
\name{directional_light}
\alias{directional_light}
\title{Generate Directional Lights}
\usage{
directional_light(direction = c(0, 1, 0), color = "white", intensity = 1)
}
\arguments{
\item{direction}{Default \code{c(0,1,0)}. Direction of the light.}

\item{color}{Default \code{white}. COlor of the light.}

\item{intensity}{Default \code{1}. Intensity of the light.}
}
\value{
A matrix representing the light information.
}
\description{
Generate Directional Lights
}
\examples{
if(run_documentation()) {
#Add a light to scene (manually specify the light automatically added to the Cornell Box
lights = point_light(position=c(555/2,450,555/2),
                    falloff_quad = 0.0, constant = 0.0002, falloff = 0.005)
generate_cornell_mesh(light=FALSE) |>
 rasterize_scene(light_info = lights)
 
#Add a directional light
lights_d = add_light(lights, directional_light(direction=c(1,1.5,-1)))

generate_cornell_mesh(light=FALSE) |>
 rasterize_scene(light_info = lights_d)
 
#Change the intensity and color
lights_d = add_light(lights, 
                    directional_light(direction=c(1,1.5,-1),color="orange", intensity=0.5))

generate_cornell_mesh(light=FALSE) |>
 rasterize_scene(light_info = lights_d)
}
}
