% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_ks.R
\name{betaks}
\alias{betaks}
\title{Calculates Beta and Ks}
\usage{
betaks(
  u,
  lat = "lat",
  lon = "lon",
  uname = "uwnd",
  ofile,
  a = 6371000,
  plots = FALSE,
  show.warnings = FALSE
)
}
\arguments{
\item{u}{String indicating the input data filename. The file to be
passed consists in a netCDF file with only time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360.
It is required that the read dimensions express
longitude (in rows) x latitude (in columns).
\strong{u} also can be a numerical matrix with time-mean zonal wind at one
pressure level, latitude in ascending order (not a requisite), and longitude
from 0 to 360. It is required that the read dimensions express longitude
(in rows) x latitude (in columns).}

\item{lat}{String indicating the name of the latitude field. If
\strong{u} is a matrix, \strong{lat} must be numeric.}

\item{lon}{String indicating the name of the longitude field.If
\strong{u} is a matrix, \strong{lat} must be numeric from 0 to 360.}

\item{uname}{String indicating the variable name field}

\item{ofile}{String indicating the file name for store output data.
If missing, will not return a netCDF file}

\item{a}{Numeric indicating the Earth's radio (m)}

\item{plots}{Logical, if TRUE will produce filled.countour plots}

\item{show.warnings}{Logical, if TRUE will warns about NaNs in sqrt(<0)}
}
\value{
list with one vector (lat) and 3 matrices (um, betam, and ksm)
}
\description{
\code{betaks} ingests the time-mean zonal wind (u), transform it in
mercator coordinates (um); calculates the meridional gradient of
the absolute vorticity (beta) in mercator coordinates (betam);
and, finally, calculates stationary wavenumber (Ks) in mercator coordinates
(ksm) (see: Hoskins and Ambrizzi, 1993). \code{betaks} returns the um, betam,
and lat, for being ingested in \code{\link{ray}} or
\code{\link{ray_source}}.
}
\examples{
{
# u is NetCDF and lat and lon characters
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                      package = "raytracing")
b <- betaks(u = input, plots = TRUE)
b$ksm[] <- ifelse(b$ksm[] >= 16 |
                  b$ksm[] <= 0, NA, b$ksm[])
cores <- c("#ff0000","#ff5a00","#ff9a00","#ffce00","#f0ff00")
graphics::filled.contour(b$ksm[, -c(1:5, 69:73)] ,
                         col = rev(colorRampPalette(cores, bias = 0.5)(20)),
                         main = "Ks")

# u, lat and lon as numeric
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.bin",
                      package = "raytracing")
u <- readBin(input,
             what = numeric(),
             size = 4,
             n = 144*73*4)
lat <- seq(-90, 90, 2.5)
lon <- seq(-180, 180 - 1, 2.5)
u <- matrix(u,
            nrow = length(lon),
            ncol = length(lat))
graphics::filled.contour(u, main = "Zonal Wind Speed [m/s]")
b <- betaks(u, lat, lon)
b$ksm[] <- ifelse(b$ksm[] >= 16 |
                  b$ksm[] <= 0, NA, b$ksm[])
cores <- c("#ff0000","#ff5a00","#ff9a00","#ffce00","#f0ff00")
graphics::filled.contour(b$ksm[, -c(1:5, 69:73)] ,
                         col = rev(colorRampPalette(cores, bias = 0.5)(20)),
                         main = "Ks")
}
}
