% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_matrix_size.R
\name{reduce_matrix_size}
\alias{reduce_matrix_size}
\title{Reduce Matrix Size}
\usage{
reduce_matrix_size(heightmap, scale = 0.5, width = NULL, height = NULL)
}
\arguments{
\item{heightmap}{The elevation matrix.}

\item{scale}{Default `0.5`. The amount to scale down the matrix. Scales down using bilinear interpolation.}

\item{width}{Default `NULL`.  Alternative to `scale` argument. The desired output width. If `width` is less than 1, it will be interpreted as a scaling factor--
e.g. 0.5 would halve the resolution for the width.}

\item{height}{Default `NULL`. Alternative to `scale` argument. The desired output width. If `height` is less than 1, it will be interpreted as a scaling factor--
e.g. 0.5 would halve the resolution for the height.}
}
\description{
Reduces the resolution of the matrix by specifyin the desired output dimensions, or a scaling factor.
}
\examples{
#Reduce the size of the monterey bay dataset by half

montbaysmall = reduce_matrix_size(montereybay, 0.5)
montbaysmall \%>\%
 sphere_shade() \%>\%
 plot_map()

#Reduce the size of the monterey bay dataset from 401x401 to 100x100

montbaysmall = reduce_matrix_size(montereybay, width = 100, height = 100)
montbaysmall \%>\%
 sphere_shade() \%>\%
 plot_map()
}
