% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_texture.R
\name{create_texture}
\alias{create_texture}
\title{Create Texture}
\usage{
create_texture(lightcolor, shadowcolor, leftcolor, rightcolor, centercolor,
  cornercolors = NULL)
}
\arguments{
\item{lightcolor}{The main highlight color. Corresponds to the top center of the texture map.}

\item{shadowcolor}{The main shadow color. Corresponds to the bottom center of the texture map. This color represents slopes directed 
directly opposite to the main highlight color.}

\item{leftcolor}{The left fill color. Corresponds to the left center of the texture map. This color represents slopes directed 
90 degrees to the left of the main highlight color.}

\item{rightcolor}{The right fill color. Corresponds to the right center of the texture map. This color represents slopes directed 
90 degrees to the right of the main highlight color.}

\item{centercolor}{The center color. Corresponds to the center of the texture map. This color represents flat areas.}

\item{cornercolors}{Default `NULL`. The colors at the corners, in this order: NW, NE, SW, SE. If this vector isn't present (or
all corners are specified), the mid-points will just be interpolated from the main colors.}
}
\description{
Creates a texture map based on 5 user-supplied colors.
}
\examples{
#Here is the `imhof1` palette:
create_texture("#fff673","#55967a","#8fb28a","#55967a","#cfe0a9") \%>\%
 plot_map()

#Here is the `unicorn` palette:
create_texture("red","green","blue","yellow","white") \%>\%
 plot_map()
}
