% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_objects.R
\name{animate_objects}
\alias{animate_objects}
\title{Animate Objects}
\usage{
animate_objects(
  scene,
  start_time = 0,
  end_time = 1,
  start_pivot_point = c(0, 0, 0),
  start_position = c(0, 0, 0),
  start_angle = c(0, 0, 0),
  start_order_rotation = c(1, 2, 3),
  start_scale = c(1, 1, 1),
  start_axis_rotation = NA,
  end_pivot_point = c(0, 0, 0),
  end_position = c(0, 0, 0),
  end_angle = c(0, 0, 0),
  end_order_rotation = c(1, 2, 3),
  end_scale = c(1, 1, 1),
  end_axis_rotation = NA
)
}
\arguments{
\item{scene}{Tibble of pre-existing object locations.}

\item{start_time}{Default `0`. Start time of movement.}

\item{end_time}{Default `1`. End time of movement.}

\item{start_pivot_point}{Default `c(0,0,0)`. The point about which to pivot, scale, and move the objects.}

\item{start_position}{Default `c(0,0,0)`. Vector indicating where to offset the objects.}

\item{start_angle}{Default `c(0,0,0)`. Angle of rotation around the x, y, and z axes, 
applied in the order specified in `order_rotation`.}

\item{start_order_rotation}{Default `c(1,2,3)`. The order to apply the rotations, 
referring to "x", "y", and "z".}

\item{start_scale}{Default `c(1,1,1)`. Scaling factor for x, y, and z directions for all objects.}

\item{start_axis_rotation}{Default `NA`. Provide an axis of rotation and a single angle (via `angle`) of rotation}

\item{end_pivot_point}{Default `c(0,0,0)`. The point about which to pivot, scale, and move the group.}

\item{end_position}{Default `c(0,0,0)`. Vector indicating where to offset the objects.}

\item{end_angle}{Default `c(0,0,0)`. Angle of rotation around the x, y, and z axes, 
applied in the order specified in `order_rotation`.}

\item{end_order_rotation}{Default `c(1,2,3)`. The order to apply the rotations, 
referring to "x", "y", and "z".}

\item{end_scale}{Default `c(1,1,1)`. Scaling factor for x, y, and z directions for all objects.}

\item{end_axis_rotation}{Default `NA`. Provide an axis of rotation and a single angle (via `angle`) of rotation
around that axis.}
}
\value{
Tibble of animated object.
}
\description{
This function animates an object between two states. This animates objects separately from the transformations set
in `group_objects()` and in the object transformations themselves. This creates motion blur, controlled by the shutter
open/close options in `render_scene()`.
}
\examples{
#Render a pig
if(run_documentation()) {
generate_studio() \%>\% 
  add_object(pig(y=-1.2,scale=0.5,angle=c(0,-70,0)))\%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue")
}
if(run_documentation()) {
#Render a moving pig
generate_studio() \%>\% 
  add_object(
    animate_objects(
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_position = c(-0.1,0,0), end_position = c(0.1,0.2,0))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10)
}
if(run_documentation()) {

#Render a shrinking pig
generate_studio() \%>\% 
  add_object(
    animate_objects(
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_scale = c(1,1,1), end_scale = c(0.5,0.5,0.5))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10)
}
if(run_documentation()) {
#Render a spinning pig
generate_studio() \%>\% 
  add_object(
    animate_objects(
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_angle = c(0,-30,0), end_angle = c(0,30,0))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10)
}
if(run_documentation()) {

#Shorten the open shutter time frame
generate_studio() \%>\% 
  add_object(
    animate_objects(
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_angle = c(0,-30,0), end_angle = c(0,30,0))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10, 
               shutteropen=0.4, shutterclose = 0.6)
}
if(run_documentation()) {
#Change the time frame when the shutter is open
generate_studio() \%>\% 
  add_object(
    animate_objects(
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_angle = c(0,-30,0), end_angle = c(0,30,0))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10, 
               shutteropen=0, shutterclose = 0.1)
}
if(run_documentation()) {    
#Shorten the time span in which the movement occurs (which, in effect, 
#increases the speed of the transition).
generate_studio() \%>\% 
  add_object(
    animate_objects(start_time = 0, end_time=0.1,
      pig(y=-1.2,scale=0.5,angle=c(0,-70,0)),
      start_angle = c(0,-30,0), end_angle = c(0,30,0))
  ) \%>\% 
  add_object(sphere(y=5,x=5,z=5,radius=2,material=light())) \%>\% 
  render_scene(samples=128,sample_method = "sobol_blue",clamp_value = 10, 
               shutteropen=0, shutterclose = 0.1)
}
}
