% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{triangle}
\alias{triangle}
\title{Triangle Object}
\usage{
triangle(
  v1 = c(1, 0, 0),
  v2 = c(0, 1, 0),
  v3 = c(-1, 0, 0),
  n1 = rep(NA, 3),
  n2 = rep(NA, 3),
  n3 = rep(NA, 3),
  color1 = rep(NA, 3),
  color2 = rep(NA, 3),
  color3 = rep(NA, 3),
  material = diffuse(),
  angle = c(0, 0, 0),
  order_rotation = c(1, 2, 3),
  flipped = FALSE,
  reversed = FALSE,
  scale = c(1, 1, 1)
)
}
\arguments{
\item{v1}{Default `c(1, 0, 0)`. Length-3 vector indicating the x, y, and z coordinate of the first triangle vertex.}

\item{v2}{Default `c(0, 1, 0)`. Length-3 vector indicating the x, y, and z coordinate of the second triangle vertex.}

\item{v3}{Default `c(-1, 0, 0)`. Length-3 vector indicating the x, y, and z coordinate of the third triangle vertex.}

\item{n1}{Default `NA`. Length-3 vector indicating the normal vector associated with the first triangle vertex.}

\item{n2}{Default `NA`. Length-3 vector indicating the normal vector associated with the second triangle vertex.}

\item{n3}{Default `NA`. Length-3 vector indicating the normal vector associated with the third triangle vertex.}

\item{color1}{Default `NA`. Length-3 vector or string indicating the color associated with the first triangle vertex. 
If NA but other vertices specified, color inherits from material.}

\item{color2}{Default `NA`. Length-3 vector or string indicating the color associated with the second triangle vertex.
If NA but other vertices specified, color inherits from material.}

\item{color3}{Default `NA`. Length-3 vector or string indicating the color associated with the third triangle vertex.
If NA but other vertices specified, color inherits from material.}

\item{material}{Default  \code{\link{diffuse}}.The material, called from one of the material 
functions \code{\link{diffuse}}, \code{\link{metal}}, or \code{\link{dielectric}}.}

\item{angle}{Default `c(0, 0, 0)`. Angle of rotation around the x, y, and z axes, applied in the order specified in `order_rotation`.}

\item{order_rotation}{Default `c(1, 2, 3)`. The order to apply the rotations, referring to "x", "y", and "z".}

\item{flipped}{Default `FALSE`. Whether to flip the normals.}

\item{reversed}{Default `FALSE`. Similar to the `flipped` argument, but this reverses the handedness of the 
triangle so it will be oriented in the opposite direction.}

\item{scale}{Default `c(1, 1, 1)`. Scale transformation in the x, y, and z directions. If this is a single value,
number, the object will be scaled uniformly.
Note: emissive objects may not currently function correctly when scaled.}
}
\value{
Single row of a tibble describing the XZ plane in the scene.
}
\description{
Triangle Object
}
\examples{
#Generate a triangle in the Cornell box.
if(rayrender:::run_documentation()) {
generate_cornell() \%>\%
  add_object(triangle(v1 = c(100, 100, 100), v2 = c(555/2, 455, 455), v3 = c(455, 100, 100),
                      material = diffuse(color = "purple"))) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 128, parallel = TRUE, clamp_value = 5)
}
#Pass individual colors to each vertex: 
if(rayrender:::run_documentation()) {
generate_cornell() \%>\%
  add_object(triangle(v1 = c(100, 100, 100), v2 = c(555/2, 455, 455), v3 = c(455, 100, 100),
                      color1 = "green", color2 = "yellow", color3 = "red")) \%>\%
  render_scene(lookfrom = c(278, 278, -800) ,lookat = c(278, 278, 0), fov = 40, 
               ambient_light = FALSE, samples = 128, parallel = TRUE, clamp_value = 5)
}
}
