% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-mesh-from-volume.R
\name{mesh_from_volume}
\alias{mesh_from_volume}
\title{Generate 3D mesh surface from volume data}
\usage{
mesh_from_volume(
  volume,
  output_format = c("rgl", "freesurfer"),
  IJK2RAS = NULL,
  threshold = 0,
  verbose = TRUE,
  remesh = TRUE,
  remesh_voxel_size = 1,
  remesh_multisample = TRUE,
  remesh_automerge = TRUE,
  smooth = FALSE,
  smooth_lambda = 10,
  smooth_delta = 20,
  smooth_method = "surfPreserveLaplace"
)
}
\arguments{
\item{volume}{3-dimensional volume array}

\item{output_format}{resulting data format, choices are \code{'rgl'} and
\code{'freesurfer'}}

\item{IJK2RAS}{volume 'IJK' (zero-indexed coordinate index) to
\code{'tkrRAS'} transform, default is automatically determined}

\item{threshold}{threshold used to create volume mask; the surface will be
created to fit the mask boundaries}

\item{verbose}{whether to verbose the progress}

\item{remesh}{whether to re-sample the mesh using \code{\link[Rvcg]{vcgUniformRemesh}}}

\item{remesh_voxel_size, remesh_multisample, remesh_automerge}{see
arguments in \code{\link[Rvcg]{vcgUniformRemesh}}}

\item{smooth}{whether to smooth the mesh via \code{\link[Rvcg]{vcgSmooth}}}

\item{smooth_lambda, smooth_delta, smooth_method}{see \code{\link[Rvcg]{vcgSmooth}}}
}
\value{
A \code{'mesh3d'} surface if \code{output_format} is 'rgl', or
\code{'fs.surface'} surface otherwise.
}
\description{
Internally calls \code{\link[Rvcg]{vcgIsosurface}}, optionally
calls \code{\link[Rvcg]{vcgUniformRemesh}} and \code{\link[Rvcg]{vcgSmooth}}.
}
\examples{


volume <- array(0, dim = c(8,8,8))
volume[4:5, 4:5, 4:5] <- 1

graphics::image(x = volume[4,,])

# you can use rgl::wire3d(mesh) to visualize the mesh
mesh <- mesh_from_volume(volume, verbose = FALSE)


}
