% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{raveio-option}
\alias{raveio-option}
\alias{raveio_setopt}
\alias{raveio_resetopt}
\alias{raveio_getopt}
\alias{raveio_confpath}
\title{Set/Get 'raveio' option}
\usage{
raveio_setopt(key, value, .save = TRUE)

raveio_resetopt(all = FALSE)

raveio_getopt(key, default = NA, temp = TRUE)

raveio_confpath(cfile = "settings.yaml")
}
\arguments{
\item{key}{character, option name}

\item{value}{character or logical of length 1, option value}

\item{.save}{whether to save to local drive, internally used to temporary
change option. Not recommended to use it directly.}

\item{all}{whether to reset all non-default keys}

\item{default}{is key not found, return default value}

\item{temp}{when saving, whether the key-value pair should be considered
temporary, a temporary settings will be ignored when saving; when getting
options, setting \code{temp} to false will reveal the actual settings.}

\item{cfile}{file name in configuration path}
}
\value{
\code{raveio_setopt} returns modified \code{value};
\code{raveio_resetopt} returns current settings as a list;
\code{raveio_confpath} returns absolute path for the settings file;
\code{raveio_getopt} returns the settings value to the given key, or
\code{default} if not found.
}
\description{
Persist settings on local configuration file
}
\details{
\code{raveio_setopt} stores key-value pair in local path.
The values are persistent and shared across multiple sessions.
There are some read-only keys such as \code{"session_string"}. Trying to
set those keys will result in error.

\code{raveio_getopt} returns value corresponding to the keys. If key is
missing, the whole option will be returned.

If set \code{all=TRUE}, \code{raveio_resetopt} resets all keys including
non-standard ones. However \code{"session_string"} will never reset.
}
\seealso{
\code{R_user_dir}
}
