% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-components.R
\name{simple_layout}
\alias{simple_layout}
\title{Simple input-output layout}
\usage{
simple_layout(
  input_ui,
  output_ui,
  input_width = 4L,
  container_fixed = FALSE,
  container_style = NULL,
  scroll = FALSE
)
}
\arguments{
\item{input_ui}{the 'HTML' tags for the inputs}

\item{output_ui}{the 'HTML' tags for the outputs}

\item{input_width}{width of inputs, must be an integer from 1 to 11}

\item{container_fixed}{whether the maximum width of the container should be
fixed; default is no}

\item{container_style}{additional 'CSS' style of the container}

\item{scroll}{whether to stretch the container to full-heights and
scroll the input and output separately.}
}
\value{
'HTML' tags
}
\description{
Provides simple layout, with inputs on the left, and outputs
on the right. Only useful in \code{'shidashi'} framework.
}
\examples{

library(shiny)
library(ravedash)

simple_layout(
  input_ui = list(
    ravedash::input_card(
      title = "Data Selection",
      "Add inputs here"
    )
  ),
  output_ui = list(
    ravedash::output_card(
      title = "Result A",
      "Add outputs here"
    )
  )
)


}
