% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server-common.R
\name{module_server_common}
\alias{module_server_common}
\title{Default module server function}
\usage{
module_server_common(
  module_id,
  check_data_loaded,
  ...,
  session = shiny::getDefaultReactiveDomain(),
  parse_env = NULL
)
}
\arguments{
\item{module_id}{'RAVE' module ID}

\item{check_data_loaded}{a function that takes zero to one argument and
must return either \code{TRUE} if data has been loaded or \code{FALSE}
if loader needs to be open to load data.}

\item{...}{ignored}

\item{session}{shiny session}

\item{parse_env}{environment used to parse module}
}
\value{
A list of server utility functions; see 'Examples' below.
}
\description{
Common shiny server function to enable modules that requires
data loader panel.
}
\examples{

# Debug in non-reactive session: create fake session
fake_session <- shiny::MockShinySession$new()

# register common-server function
module_server_common(module_id = "mock-session",
                     session = fake_session)
server_tools <- get_default_handlers(fake_session)

# Print each function to see the usage

server_tools$auto_recalculate

server_tools$run_analysis_onchange

server_tools$run_analysis_flag

server_tools$module_is_active

server_tools$simplify_view

# 'RAVE' module server function
server <- function(input, output, session, ...){

  pipeline_path <- "PATH to module pipeline"

  module_server_common(
    module_id = session$ns(NULL),
    check_data_loaded = function(first_time){

      re <- tryCatch({
        # Try to read data from pipeline results
        repo <- raveio::pipeline_read(
          'repository',
          pipe_dir = pipeline_path
        )

        # Fire event to update footer message
        ravedash::fire_rave_event('loader_message',
                                  "Data loaded")

        # Return TRUE indicating data has been loaded
        TRUE
      }, error = function(e){

        # Fire event to remove footer message
        ravedash::fire_rave_event('loader_message', NULL)

        # Return FALSE indicating no data has been found
        FALSE
      })
    }, session = session
  )

}

}
