% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{isPolynomial}
\alias{isPolynomial}
\title{Whether a 'ratioOfQsprays' is polynomial}
\usage{
isPolynomial(roq)
}
\arguments{
\item{roq}{a \code{ratioOfQsprays} object}
}
\value{
A Boolean value.
}
\description{
Checks whether a \code{ratioOfQsprays} actually is polynomial,
  that is, whether its denominator is a constant \code{qspray} polynomial
  (and then it should be equal to one).
}
\examples{
x <- qlone(1)
y <- qlone(2)
roq <- (x^2 - y^2) / (x - y)
isPolynomial(roq)
roq == x + y
}
