% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rater_fit_class.R
\name{summary.optim_fit}
\alias{summary.optim_fit}
\title{Summarise an \code{optim_fit} object}
\usage{
\method{summary}{optim_fit}(object, n_pars = 8, ...)
}
\arguments{
\item{object}{An object of class \code{optim_fit}.}

\item{n_pars}{The number of pi/theta parameters and z 'items' to display.}

\item{...}{Other arguments passed to function.}
}
\description{
Summarise an \code{optim_fit} object
}
\details{
For the class conditional model the 'full' theta parameterisation
(i.e. appearing to have the same number of parameters as the standard
Dawid-Skene model) is calculated and returned. This is designed to allow
easier comparison with the full Dawid-Skene model.
}
\examples{
\donttest{

fit <- rater(anesthesia, "dawid_skene", method = "optim")

summary(fit)

}

}
