// Generated by rstantools.  Do not edit by hand.

/*
    rater is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rater is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rater.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_class_conditional_dawid_skene_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_class_conditional_dawid_skene");
    reader.add_event(55, 53, "end", "model_class_conditional_dawid_skene");
    return reader;
}
#include <stan_meta_header.hpp>
class model_class_conditional_dawid_skene
  : public stan::model::model_base_crtp<model_class_conditional_dawid_skene> {
private:
        int N;
        int J;
        int K;
        int I;
        std::vector<int> ii;
        std::vector<int> jj;
        std::vector<int> y;
        vector_d alpha;
        vector_d beta_1;
        vector_d beta_2;
public:
    model_class_conditional_dawid_skene(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_class_conditional_dawid_skene(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_class_conditional_dawid_skene_namespace::model_class_conditional_dawid_skene";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            check_greater_or_equal(function__, "J", J, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "I", "int", context__.to_vec());
            I = int(0);
            vals_i__ = context__.vals_i("I");
            pos__ = 0;
            I = vals_i__[pos__++];
            check_greater_or_equal(function__, "I", I, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("ii", "N", N);
            context__.validate_dims("data initialization", "ii", "int", context__.to_vec(N));
            ii = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("ii");
            pos__ = 0;
            size_t ii_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < ii_k_0_max__; ++k_0__) {
                ii[k_0__] = vals_i__[pos__++];
            }
            size_t ii_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < ii_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ii[i_0__]", ii[i_0__], 1);
                check_less_or_equal(function__, "ii[i_0__]", ii[i_0__], I);
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("jj", "N", N);
            context__.validate_dims("data initialization", "jj", "int", context__.to_vec(N));
            jj = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("jj");
            pos__ = 0;
            size_t jj_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < jj_k_0_max__; ++k_0__) {
                jj[k_0__] = vals_i__[pos__++];
            }
            size_t jj_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < jj_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "jj[i_0__]", jj[i_0__], 1);
                check_less_or_equal(function__, "jj[i_0__]", jj[i_0__], J);
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N));
            y = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_i__[pos__++];
            }
            size_t y_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "y[i_0__]", y[i_0__], 0);
                check_less_or_equal(function__, "y[i_0__]", y[i_0__], K);
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("alpha", "K", K);
            context__.validate_dims("data initialization", "alpha", "vector_d", context__.to_vec(K));
            alpha = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("alpha");
            pos__ = 0;
            size_t alpha_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
                alpha(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "alpha", alpha, 0);
            current_statement_begin__ = 11;
            validate_non_negative_index("beta_1", "K", K);
            context__.validate_dims("data initialization", "beta_1", "vector_d", context__.to_vec(K));
            beta_1 = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("beta_1");
            pos__ = 0;
            size_t beta_1_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < beta_1_j_1_max__; ++j_1__) {
                beta_1(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "beta_1", beta_1, 0);
            current_statement_begin__ = 12;
            validate_non_negative_index("beta_2", "K", K);
            context__.validate_dims("data initialization", "beta_2", "vector_d", context__.to_vec(K));
            beta_2 = Eigen::Matrix<double, Eigen::Dynamic, 1>(K);
            vals_r__ = context__.vals_r("beta_2");
            pos__ = 0;
            size_t beta_2_j_1_max__ = K;
            for (size_t j_1__ = 0; j_1__ < beta_2_j_1_max__; ++j_1__) {
                beta_2(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "beta_2", beta_2, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 16;
            validate_non_negative_index("pi", "K", K);
            num_params_r__ += (K - 1);
            current_statement_begin__ = 17;
            validate_non_negative_index("theta", "J", J);
            validate_non_negative_index("theta", "K", K);
            num_params_r__ += (J * K);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_class_conditional_dawid_skene() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 16;
        if (!(context__.contains_r("pi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable pi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("pi");
        pos__ = 0U;
        validate_non_negative_index("pi", "K", K);
        context__.validate_dims("parameter initialization", "pi", "vector_d", context__.to_vec(K));
        Eigen::Matrix<double, Eigen::Dynamic, 1> pi(K);
        size_t pi_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            pi(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.simplex_unconstrain(pi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable pi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 17;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "J", J);
        validate_non_negative_index("theta", "K", K);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(J,K));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(J, K);
        size_t theta_j_2_max__ = K;
        size_t theta_j_1_max__ = J;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(0, 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 16;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> pi;
            (void) pi;  // dummy to suppress unused var warning
            if (jacobian__)
                pi = in__.simplex_constrain(K, lp__);
            else
                pi = in__.simplex_constrain(K);
            current_statement_begin__ = 17;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_lub_constrain(0, 1, J, K, lp__);
            else
                theta = in__.matrix_lub_constrain(0, 1, J, K);
            // transformed parameters
            current_statement_begin__ = 21;
            validate_non_negative_index("log_p_z", "K", K);
            validate_non_negative_index("log_p_z", "I", I);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > log_p_z(I, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(K));
            stan::math::initialize(log_p_z, DUMMY_VAR__);
            stan::math::fill(log_p_z, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 23;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 24;
                stan::model::assign(log_p_z, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::log(pi), 
                            "assigning variable log_p_z");
            }
            current_statement_begin__ = 27;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 28;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 29;
                    if (as_bool(logical_eq(k, get_base1(y, n, "y", 1)))) {
                        current_statement_begin__ = 30;
                        stan::model::assign(log_p_z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(ii, n, "ii", 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(log_p_z, get_base1(ii, n, "ii", 1), "log_p_z", 1), k, "log_p_z", 2) + stan::math::log(get_base1(theta, get_base1(jj, n, "jj", 1), k, "theta", 1))), 
                                    "assigning variable log_p_z");
                    } else {
                        current_statement_begin__ = 32;
                        stan::model::assign(log_p_z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(ii, n, "ii", 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    ((get_base1(get_base1(log_p_z, get_base1(ii, n, "ii", 1), "log_p_z", 1), k, "log_p_z", 2) + log1m(get_base1(theta, get_base1(jj, n, "jj", 1), k, "theta", 1))) - stan::math::log((K - 1))), 
                                    "assigning variable log_p_z");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 21;
            size_t log_p_z_k_0_max__ = I;
            size_t log_p_z_j_1_max__ = K;
            for (size_t k_0__ = 0; k_0__ < log_p_z_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < log_p_z_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(log_p_z[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: log_p_z" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_p_z: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 41;
            lp_accum__.add(dirichlet_log<propto__>(pi, alpha));
            current_statement_begin__ = 43;
            for (int j = 1; j <= J; ++j) {
                current_statement_begin__ = 44;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 45;
                    lp_accum__.add(beta_log<propto__>(get_base1(theta, j, k, "theta", 1), get_base1(beta_1, k, "beta_1", 1), get_base1(beta_2, k, "beta_2", 1)));
                }
            }
            current_statement_begin__ = 49;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 51;
                lp_accum__.add(log_sum_exp(get_base1(log_p_z, i, "log_p_z", 1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("pi");
        names__.push_back("theta");
        names__.push_back("log_p_z");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dims__.push_back(K);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(I);
        dims__.push_back(K);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_class_conditional_dawid_skene_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> pi = in__.simplex_constrain(K);
        size_t pi_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            vars__.push_back(pi(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_lub_constrain(0, 1, J, K);
        size_t theta_j_2_max__ = K;
        size_t theta_j_1_max__ = J;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 21;
            validate_non_negative_index("log_p_z", "K", K);
            validate_non_negative_index("log_p_z", "I", I);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > log_p_z(I, Eigen::Matrix<double, Eigen::Dynamic, 1>(K));
            stan::math::initialize(log_p_z, DUMMY_VAR__);
            stan::math::fill(log_p_z, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 23;
            for (int i = 1; i <= I; ++i) {
                current_statement_begin__ = 24;
                stan::model::assign(log_p_z, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            stan::math::log(pi), 
                            "assigning variable log_p_z");
            }
            current_statement_begin__ = 27;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 28;
                for (int k = 1; k <= K; ++k) {
                    current_statement_begin__ = 29;
                    if (as_bool(logical_eq(k, get_base1(y, n, "y", 1)))) {
                        current_statement_begin__ = 30;
                        stan::model::assign(log_p_z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(ii, n, "ii", 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(log_p_z, get_base1(ii, n, "ii", 1), "log_p_z", 1), k, "log_p_z", 2) + stan::math::log(get_base1(theta, get_base1(jj, n, "jj", 1), k, "theta", 1))), 
                                    "assigning variable log_p_z");
                    } else {
                        current_statement_begin__ = 32;
                        stan::model::assign(log_p_z, 
                                    stan::model::cons_list(stan::model::index_uni(get_base1(ii, n, "ii", 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    ((get_base1(get_base1(log_p_z, get_base1(ii, n, "ii", 1), "log_p_z", 1), k, "log_p_z", 2) + log1m(get_base1(theta, get_base1(jj, n, "jj", 1), k, "theta", 1))) - stan::math::log((K - 1))), 
                                    "assigning variable log_p_z");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t log_p_z_j_1_max__ = K;
                size_t log_p_z_k_0_max__ = I;
                for (size_t j_1__ = 0; j_1__ < log_p_z_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < log_p_z_k_0_max__; ++k_0__) {
                        vars__.push_back(log_p_z[k_0__](j_1__));
                    }
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_class_conditional_dawid_skene";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t pi_j_1_max__ = K;
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_2_max__ = K;
        size_t theta_j_1_max__ = J;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_p_z_j_1_max__ = K;
            size_t log_p_z_k_0_max__ = I;
            for (size_t j_1__ = 0; j_1__ < log_p_z_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < log_p_z_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "log_p_z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t pi_j_1_max__ = (K - 1);
        for (size_t j_1__ = 0; j_1__ < pi_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pi" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_j_2_max__ = K;
        size_t theta_j_1_max__ = J;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t log_p_z_j_1_max__ = K;
            size_t log_p_z_k_0_max__ = I;
            for (size_t j_1__ = 0; j_1__ < log_p_z_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < log_p_z_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "log_p_z" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_class_conditional_dawid_skene_namespace::model_class_conditional_dawid_skene stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
