% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_list.R
\name{aqs_list}
\alias{aqs_list}
\alias{list_states}
\alias{list_countiesbystate}
\alias{list_sitesbycounty}
\alias{list_cbsas}
\alias{list_classes}
\alias{list_parametersbyclass}
\alias{list_pqaos}
\alias{list_mas}
\alias{list_durations}
\title{AQS API List service}
\usage{
aqs_list(
  aqs_filter = c("states", "countiesByState", "sitesByCounty", "cbsas", "classes",
    "parametersByClass", "pqaos", "mas", "durations"),
  aqs_variables = NULL,
  header = FALSE,
  ...
)

list_states(email = get_aqs_email(), key = get_aqs_key(), header = FALSE, ...)

list_countiesbystate(
  state,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

list_sitesbycounty(
  state,
  county,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

list_cbsas(email = get_aqs_email(), key = get_aqs_key(), header = FALSE, ...)

list_classes(email = get_aqs_email(), key = get_aqs_key(), header = FALSE, ...)

list_parametersbyclass(
  pc,
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)

list_pqaos(email = get_aqs_email(), key = get_aqs_key(), header = FALSE, ...)

list_mas(email = get_aqs_email(), key = get_aqs_key(), header = FALSE, ...)

list_durations(
  email = get_aqs_email(),
  key = get_aqs_key(),
  header = FALSE,
  ...
)
}
\arguments{
\item{aqs_filter}{A string specifying one of the service filters. NOT
case-sensitive.}

\item{aqs_variables}{A named list of variables to fetch data (e.g.,
\code{state}). Only necessary variables are passed to a specific endpoint
(service/filter) to make a valid request.}

\item{header}{A logical specifying whether the function returns additional
information from the API header. Default is \code{FALSE} to return data only.}

\item{...}{Reserved for future use.}

\item{email}{A string specifying the email address of the requester. If you
set your email and key with \link{set_aqs_user}, you don't have to specify
this.}

\item{key}{A string specifying the key matching the email address for the
requester. If you set your email and key with \link{set_aqs_user}, you don't
have to specify this.}

\item{state}{A string specifying the 2-digit state FIPS code. An integer
will be coerced to a string with a leading zero if necessary (e.g., 1 ->
"01"). A list of the state codes can be obtained via \link{list_states}.}

\item{county}{A string specifying the 3-digit county FIPS code. An integer
will be coerced to a string with leading zeros if necessary (e.g., 89 ->
"089"). A list of the county codes within each state can be obtained via
\link{list_countiesbystate}.}

\item{pc}{A string specifying the AQS parameter class name. A list of the
class names can be obtained via \link{list_classes}.}
}
\value{
A data.frame containing parsed data or a named list containing
header and data.
}
\description{
A collection of functions to fetch variable values you need to create other
service requests. All outputs are a value and the definition of that value.
}
\details{
\link{aqs_list} sends a request to the AQS API based on a user-provided filter
using the following underlying functions:
\itemize{
\item \link{list_states} returns a list of the states and their FIPS codes.
\item \link{list_countiesbystate} returns a list of all counties within a
user-provided state.
\item \link{list_sitesbycounty} returns a list of all sites within a user-provided
county.
\item \link{list_cbsas} returns a list of the 5-digit Core Based Statistical Area
(CBSA) codes.
\item \link{list_classes} returns a list of parameter class codes.
\item \link{list_parametersbyclass} returns all parameters in a user-provided
parameter class.
\item \link{list_pqaos} returns a list of AQS Primary Quality Assurance Organization
(PQAO) codes.
\item \link{list_mas} returns a list of AQS Monitoring Agency (MA) codes.
\item \link{list_durations} returns a list of the 1-character AQS sample duration
codes.
}
}
\examples{
\dontrun{

## Set your API Key first using set_aqs_user to run the following codes

aqs_list(aqs_filter = "states")
list_states() # equivalent to above

aqs_list("countiesByState", aqs_variables = list(state = "01"))
list_countiesbystate(state = "01")

aqs_list("sitesByCounty", aqs_variables = list(state = "37", county = "183"))
list_sitesbycounty(state = "37", county = "183")

aqs_list("cbsas")
list_cbsas()

aqs_list("classes")
list_classes()

aqs_list("parametersByClass", list(pc = "CRITERIA")) # Criteria pollutants
list_parametersbyclass(pc = "CRITERIA")

aqs_list("pqaos")
list_pqaos()

aqs_list("mas")
list_mas()

aqs_list("durations")
list_durations()
}

}
