% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RapData.R
\name{RapData}
\alias{RapData}
\title{Create new RapData object}
\usage{
RapData(
  pu,
  species,
  targets,
  pu.species.probabilities,
  attribute.spaces,
  boundary,
  polygons = NA,
  skipchecks = FALSE,
  .cache = new.env()
)
}
\arguments{
\item{pu}{\code{\link[base:data.frame]{base::data.frame()}} planning unit data. Columns must be
"cost" (\code{numeric}), "area" (\code{numeric}), and "status"
(\code{integer}).}

\item{species}{\code{\link[base:data.frame]{base::data.frame()}} with species data. Columns
must be "name" (\code{character}).}

\item{targets}{\code{\link[base:data.frame]{base::data.frame()}} with species data.
Columns must be "species" (\code{integer}), "target" (\code{integer}),
"proportion" (\code{numeric}).}

\item{pu.species.probabilities}{\code{\link[base:data.frame]{base::data.frame()}} with data on
the probability of species in each planning unit. Columns must be
"species", (\code{integer}), "pu" (\code{integer}), and "value"
(\code{numeric}).}

\item{attribute.spaces}{\code{list} of \code{\link[=AttributeSpaces]{AttributeSpaces()}} objects
with the demand points and planning unit coordinates.}

\item{boundary}{\code{\link[base:data.frame]{base::data.frame()}} with data on the shared
boundary length of planning units. Columns must be "id1"
(\code{integer}), "id2" (\code{integer}), and "boundary" (\code{integer}).}

\item{polygons}{\code{\link[PBSmapping:PolySet]{PBSmapping::PolySet()}} planning unit spatial data
or \code{NULL} if data not available.}

\item{skipchecks}{\code{logical} Skip data integrity checks? May improve
speed for big data sets.}

\item{.cache}{\code{\link[base:environment]{base::environment()}} used to cache calculations.}
}
\value{
RapData object
}
\description{
This function creates a "RapData" object using pre-processed data.
}
\note{
Generally, users are not encouraged to change arguments to
\code{.cache}.
}
\examples{
# load data
data(cs_pus, cs_spp, cs_space)

# create data for RapData object
attribute.spaces <- list(
  AttributeSpaces(name = "geographic", list(
    AttributeSpace(
      planning.unit.points = PlanningUnitPoints(
        rgeos::gCentroid(cs_pus[1:10,], byid = TRUE)@coords, seq_len(10)),
      demand.points = make.DemandPoints(
        randomPoints(cs_spp[[1]], n = 10, prob = TRUE)),
      species = 1L))),
  AttributeSpaces(name = "environmental", list(
    AttributeSpace(
      planning.unit.points = PlanningUnitPoints(
        raster::extract(cs_space[[1]], cs_pus[1:10,], fun = mean),
        seq_len(10)),
      demand.points = make.DemandPoints(
        cs_space[[1]][raster::Which(!is.na(cs_space[[1]]))]),
        species = 1L))))
pu.species.probabilities <- calcSpeciesAverageInPus(cs_pus[1:10,],
                                                    cs_spp[[1]])
polygons <- SpatialPolygons2PolySet(cs_pus[1:10,])
boundary <- calcBoundaryData(cs_pus[1:10,])

x <- RapData(pu = cs_pus@data[1:10,], species = data.frame(name = "test"),
             target = data.frame(species = 1L, target = 0:2,
                                 proportion = 0.2),
             pu.species.probabilities = pu.species.probabilities,
             attribute.spaces = attribute.spaces,
             polygons = polygons,
             boundary = boundary)

# print object
print(x)

}
\seealso{
\code{\link[PBSmapping:PolySet]{PBSmapping::PolySet()}}, \code{\link[sp:SpatialPoints]{sp::SpatialPoints()}},
\code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}}, \code{\link[=make.RapData]{make.RapData()}},
\linkS4class{RapData}.
}
