% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/export.R
\name{rapport.export}
\alias{rapport.export}
\alias{tpl.export}
\title{Export rapport object}
\usage{
rapport.export(rp = NULL, file, append = FALSE, create = TRUE,
  open = TRUE, date = pander_return(Sys.time()), description = TRUE,
  format = "html", options = "", logo = TRUE)
}
\arguments{
\item{rp}{a rapport class object or list of rapport class objects}

\item{file}{filename of the generated document. Inherited from rapport class if not set. If \code{file} is set with path (not equal to \code{getwd()}), please set an absolute path for images (see: \code{evalsOptions()}).}

\item{append}{FALSE (new report created) or an R object (class of "Report") to which the new report will be added}

\item{create}{should export really happen? It might be handy if you want to append several reports.}

\item{open}{open the exported document? Default set to TRUE.}

\item{date}{character string as the date field of the report. If not set, current time will be set.}

\item{description}{add \code{Description} of the rapport class (template)? Default set to TRUE.}

\item{format}{format of the wanted report. See Pandoc's user manual for details. In short, choose something like: \code{html}, \code{pdf}, \code{odt} or \code{docx}.}

\item{options}{options passed to \code{Pandoc.convert}.}

\item{logo}{add rapport logo}
}
\value{
filepath on \code{create = TRUE}, \code{Report} class otherwise
}
\description{
This function exports rapport class objects to various formats based on the \code{pander} package.
}
\details{
By default this function tries to export the report to HTML with pandoc. Some default styles are applied. If you do not like those default settings, use your own \code{options} argument.

Default parameters are read from global \code{options}:

\itemize{
    \item 'rapport.user'
}

Please be sure to set \code{'rapport.user'} option with \code{options()} to get your name in the head of your generated reports!
}
\examples{
\dontrun{

## eval some template
x <- rapport('Example', data = mtcars, var="hp")

## try basic parameters
rapport.export(x)
rapport.export(x, file = 'demo')
rapport.export(x, file = 'demo', format = 'odt')

### append reports
# 1) Create a report object with the first report and do not export (optional)
report <- rapport.export(x, create = F)
# 2) Append some other reports without exporting (optional)
report <- rapport.export(x, create = F, append = report)
# 3) Export it!
rapport.export(append=report)
# 4) Export it to other formats too! (optional)
rapport.export(append=report, format='rst')

### exporting multiple reports at once
rapport.export(rapport.example('Example', 'all'))
rapport.export(rapport.example('Example', 'all'), format = 'odt')
rapport.export(list(rapport('univar-descriptive', data = mtcars, var = "hp"),
    rapport('Descriptives', data = mtcars, var = "mpg")))

### Never do this as being dumb:
rapport.export()

### Adding own custom CSS to exported HTML
rapport.export(x, options =
    sprintf('-c \%s', system.file('templates/css/default.css', package='rapport')))
}
}
\references{
John MacFarlane (2012): _Pandoc User's Guide_. \url{http://johnmacfarlane.net/pandoc/README.html}
}
\seealso{
\code{\link{rapport.html}} \code{\link{rapport.pdf}} \code{\link{rapport.odt}} \code{\link{rapport.docx}}
}

