% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoReportFuns.R
\name{createAutoReport}
\alias{createAutoReport}
\title{Create and add report to config}
\usage{
createAutoReport(synopsis, package, fun, paramNames, paramValues, owner,
  email, organization, runDayOfYear, dryRun = FALSE)
}
\arguments{
\item{synopsis}{String with description of the report and to be used in
subject field of email distributed reports}

\item{package}{String with package name also corresponding to registry}

\item{fun}{String providing name of function to be called for generating
report}

\item{paramNames}{String vector where each element corresponds to the input
parameter to be used in the above function}

\item{paramValues}{String vector with corresponding values to paramNames}

\item{owner}{String providing the owner of the report. Usually a user name}

\item{email}{String with email address to recipient of email containing the
report}

\item{organization}{String identifying the organization the owner belongs to}

\item{runDayOfYear}{Integer vector with day numbers of the year when the
report is to be run}

\item{dryRun}{Logical defining if global auto report config actually is to
be updated. If set to TRUE the actual config (all of it) will be returned by
the function. FALSE by default}
}
\value{
Nothing unless dryRun is set TRUE in which case a list of all config
will be returned
}
\description{
Adds an entry to the system configuration of reports to run at given
intervals. After generating the configuration from the new entry
the function load the current system configuration, adds the new
entry and saves the updated system configuration.
}
\seealso{
\code{\link{deleteAutoReport}}
}
