% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_emaps.R
\name{ranges_emaps}
\alias{ranges_emaps}
\title{Plots of species ranges on maps of environmental variables}
\usage{
ranges_emaps(..., variables, add_occurrences = FALSE,
             range_colors = NULL, color_variables = NULL,
             ranges_legend = TRUE, legend_position = "bottomright",
             legend_cex = 0.7, zoom = 0.7, verbose = TRUE)
}
\arguments{
\item{...}{one or more objects of class \code{\link{sp_range}} produced with
any of the following functions: \code{\link{rangemap_buffer}},
\code{\link{rangemap_boundaries}}, \code{\link{rangemap_hull}},
\code{\link{rangemap_enm}}, and/or \code{\link{rangemap_tsa}}. Using up to
three or four ranges is recommended for more precise comparisons.}

\item{variables}{a RasterLayer or RasterStack object of environmental variables
that will be used as the base for maps. Projection is assumed to be WGS84
(EPSG:4326). Consider that depending on the species range, using more than 9
variables creates a plot that may not fit in an A4 paper sheet. A maximum of
21 variables is allowed, if this limit is surpassed, other variables will be
ignored.}

\item{add_occurrences}{(logical) if \code{TRUE}, species occurrences contained
in \code{\link{sp_range}} objects will be added to the figure. Default =
\code{FALSE}. If the none of the objects contains occurrences, this argument
will be ignored.}

\item{range_colors}{vector of colors for borders of species ranges. If
\code{NULL}, the default, distinct levels of gray will be used. If more than
3 \code{\link{sp_range}} objects are included, defining your own colors is
recommended.}

\item{color_variables}{a color palette (a vector of continuous colors generated
by functions like heat.colors). If \code{NULL}, the default, rev(terrain.colors(255))
will be used.}

\item{ranges_legend}{(logical) if \code{TRUE}, a legend of the plotted ranges
will be added to the last panel of the plot at \code{legend_position}.
Default = \code{TRUE}.}

\item{legend_position}{(numeric or character) location where the legend will
be placed in the plot. If numeric, vector of length = 2 indicating x and y
coordinates to position the legend. See details in \code{\link[graphics]{legend}}
for character options of position. Default = "bottomright".}

\item{legend_cex}{(numeric) size of the legend with respect to \code{cex}
option in \code{\link[graphics]{par}}. Default = 0.7.}

\item{zoom}{(numeric) zoom factor when plotting the species range in a map
(based on the largest range). Default = 1.3. Larger values will zoom in into
the species range and smaller values will zoom out. A value of 0.5 will
duplicate the area that the biggest range is covering.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A plot showing species ranges on top of maps of environmental variables.
}
\description{
ranges_emaps plots one or more ranges of the same species on
various maps of environmental factors (e.g. climatic variables) to detect
implications of using one or other type of range regarding the environmental
conditions in the areas.
}
\details{
Position of distinct elements depend on the spatial configuration of the
species range. Therefore, their position may need to be changed if such
elements are needed (e.g., legend). Current character options available for
position are: "bottomright", "bottomleft", "topleft", and "topright".
}
\examples{
# example data
data("buffer_range", package = "rangemap")
data("cxhull_range", package = "rangemap")
data("cvehull_range", package = "rangemap")

vars <- raster::stack(system.file("extdata", "variables.tif",
                                  package = "rangemap"))
names(vars) <- c("bio5", "bio6", "bio13", "bio14")

# plotting
ranges_emaps(buffer_range, cxhull_range, cvehull_range, variables = vars)
}
