% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_fig.R
\name{rangemap_plot}
\alias{rangemap_plot}
\title{Plot of sp_range* objects}
\usage{
rangemap_plot(sp_range, polygons, add_EOO = FALSE, add_occurrences = FALSE,
              basemap_color = "gray93", range_color = "darkgreen",
              extent_color = "blue", occurrences_color = "yellow",
              grid = FALSE, grid_sides = "bottomleft", ylabels_position = 1.3,
              legend = FALSE, legend_position = "bottomright",
              northarrow = FALSE, northarrow_position = "topright",
              scalebar = FALSE, scalebar_position = "bottomleft",
              scalebar_length = 100, zoom = 1)
}
\arguments{
\item{sp_range}{a sp_range object produced with any of the following functions:
\code{\link{rangemap_buffer}}, \code{\link{rangemap_boundaries}},
\code{\link{rangemap_hull}}, \code{\link{rangemap_enm}}, and
\code{\link{rangemap_tsa}}.}

\item{polygons}{(optional) a SpatialPolygons* object to be used as base for
the map. If \code{NULL}, a simplified world map will be used.}

\item{add_EOO}{(logical) if \code{TRUE}, the extent of occurrence of the
species will be added to the figure. Ignored if the \code{sp_range} is product
of the \code{\link{rangemap_boundaries}} function and administrative areas were
selected only based on names. Default = \code{FALSE}.}

\item{add_occurrences}{(logical) if \code{TRUE}, the species occurrence records
will be added to the figure. Ignored if the \code{sp_range} is product of the
\code{\link{rangemap_boundaries}} function and administrative areas were selected
only based on names. Default = \code{FALSE}.}

\item{basemap_color}{color for the basemap (\code{polygons}) to be plotted.
Default = "gray93".}

\item{range_color}{color for the species \code{sp_range} to be plotted.
Default = "darkgreen".}

\item{extent_color}{color for the species extent of occurrence to be plotted.
Default = "blue".}

\item{occurrences_color}{color for the species \code{occurrences} to be plotted.
Default = "yellow".}

\item{grid}{(logical) if \code{TRUE}, labels and grid division ticks will be
inserted in \code{grid_sides}. Default = \code{FALSE}.}

\item{grid_sides}{(character) sides in which the labels will be placed in the
figure. Options are the same than for other position character indicators
(see details). Default = "bottomleft".}

\item{ylabels_position}{(numeric) if \code{grid} = \code{TRUE}, separation
(in lines) of y axis labels from the axis. Bigger numbers will increase
separation. Default = 1.3.}

\item{legend}{(logical) if \code{TRUE}, a legend of the plotted features will
be added to the figure at \code{legend_position}. Default = \code{FALSE}.}

\item{legend_position}{(numeric or character) site in the figure where the
legend will be placed. If numeric, vector of length two indicating x and y
coordinates to be used to position the legend. See details for options of
character indicators of position. Default = "bottomright".}

\item{northarrow}{(logical) if \code{TRUE}, a simple north arrow will be placed
in \code{northarrow_position}. Default = \code{FALSE}.}

\item{northarrow_position}{(numeric or character) site in the figure where the
north legend will be placed. If numeric, vector of length two indicating x and
y coordinates to be used to position the north arrow. See details for options
of character indicators of position. Default = "topright".}

\item{scalebar}{(logical) if \code{TRUE}, a simple scale bar will be inserted
in the figure at \code{scalebar_position} with a length of \code{scalebar_length}.
Default = \code{FALSE}.}

\item{scalebar_position}{(numeric or character) site in the figure where the
scale bar will be placed. If numeric, vector of length two indicating x and y
coordinates to be used to position the scale bar. See details for options of
character indicators of position. Default = "bottomleft".}

\item{scalebar_length}{(numeric) length of the scale bar in km. Using entire
numbers divisible for two is recommended. Default = 100.}

\item{zoom}{(numeric) zoom factor when plotting the species range in a map.
Default = 1. Larger values will zoom in into the species range and smaller
values will zoom out. A value of 0.5 will duplicate the area that the biggest
range is covering.}
}
\value{
A plot of the species range in a geographic context, with some map components
defined by the user.
}
\description{
rangemap_plot generates customizable figures of species range maps
using objects produced by other functions of this package.
}
\details{
Position of distinct elements depend on the spatial configuration of the
species range. Therefore, their position may need to be changed if the elements
are needed. Position options are: "bottomright", "bottomleft", "topleft", and
"topright". Numerical descriptions of positions are also allowed.
}
\examples{
# example data
data("cvehull_range", package = "rangemap")

# arguments for the species range figure
extent <- TRUE
occ <- TRUE
legend <- TRUE

# creating the species range figure
rangemap_plot(cvehull_range, add_EOO = extent, add_occurrences = occ,
              legend = legend)
}
