% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_buff.R
\name{rangemap_buffer}
\alias{rangemap_buffer}
\title{Species distributional ranges based on buffered occurrences}
\usage{
rangemap_buffer(occurrences, buffer_distance = 100000, polygons = NULL,
                final_projection = NULL, save_shp = FALSE, name,
                overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees (WGS84).}

\item{buffer_distance}{(numeric) distance, in meters, to be used for creating
the buffer areas around occurrences, default = 100000.}

\item{polygons}{(optional) a SpatialPolygons* object to clip buffer areas and
adjust the species range and other polygons to these limits. Projection must
be WGS84 (EPSG:4326). If \code{NULL}, the default, a simplified world map
will be used.}

\item{final_projection}{(character) string of projection arguments for
resulting Spatial objects. Arguments must be as in the PROJ.4 documentation.
See \code{\link[sp]{CRS-class}} for details. If \code{NULL}, the default,
projection used is WGS84 (EPSG:4326).}

\item{save_shp}{(logical) if \code{TRUE}, shapefiles of the species range,
occurrences, extent of occurrence, and area of occupancy will be written in
the working directory. Default = \code{FALSE}.}

\item{name}{(character) valid if \code{save_shp} = \code{TRUE}. The name of
the shapefile to be exported. A suffix will be added to \code{name} depending
on the object, as follows: species extent of occurrence = "_extent_occ", area
of occupancy = "_area_occ", and occurrences = "_unique_records".}

\item{overwrite}{(logical) whether or not to overwrite previous results with
the same name. Default = \code{FALSE}.}

\item{verbose}{(logical) whether or not to print messages about the process.
Default = TRUE.}
}
\value{
A sp_range object (S4) containing: (1) a data.frame with information about the
species range, and Spatial objects of (2) unique occurrences, (3) species range,
(4) extent of occurrence, and (5) area of occupancy.
}
\description{
rangemap_buffer generates a distributional range for a given
species by buffering provided occurrences using a defined distance. An approach
to the species extent of occurrence (using convex hulls) and the area of
occupancy according to the IUCN criteria is also generated. Shapefiles can
be saved in the working directory if it is needed.
}
\details{
All resulting Spatial objects in the results will be projected to the
\code{final_projection}. Areas are calculated in square kilometers using the
Lambert Azimuthal Equal Area projection, centered on the centroid of occurrence
points given as inputs.
}
\examples{
\donttest{
# getting the data
data("occ_p", package = "rangemap")

# buffer distance
dist <- 100000

buff_range <- rangemap_buffer(occurrences = occ_p, buffer_distance = dist)

summary(buff_range)
}
}
