% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edgelist.R
\name{convert_edgelist}
\alias{convert_edgelist}
\alias{convert_edgelist.default}
\alias{convert_edgelist.ranglet}
\alias{convert_edgelist.rang}
\title{Convert Data Structures to rang edgelist}
\usage{
convert_edgelist(x, ...)

\method{convert_edgelist}{default}(x, ...)

\method{convert_edgelist}{ranglet}(x, ...)

\method{convert_edgelist}{rang}(x, ...)
}
\arguments{
\item{x, }{supported data structures are \code{rang} and \code{ranglet} S3 objects}

\item{..., }{not used}
}
\value{
a data frame of directed edges of dependencies
}
\description{
This generic function converts several data structures provided by rang into an edgelist of package dependencies.
}
\details{
the resulting data frame can be converted to an igraph object for plotting and analysis via the function \code{\link[igraph:graph_from_data_frame]{igraph::graph_from_data_frame()}}
}
\examples{
\donttest{
if (interactive()) {
    graph <- resolve(pkgs = c("openNLP", "LDAvis", "topicmodels", "quanteda"),
                snapshot_date = "2020-01-16")
                
    # dependency edgelist of a single package
    convert_edgelist(graph$ranglets[[1]])
    
    # full dependency edgelist
    convert_edgelist(graph)
}
}
}
