% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt_point.R
\name{wkt_point}
\alias{wkt_point}
\title{Random WKT point}
\usage{
wkt_point(count = 1, bbox = NULL, fmt = 7)
}
\arguments{
\item{count}{(integer/numeric) number of points. Default: 1}

\item{bbox}{(integer/numeric) lat/long bounding box from which to generate
positions; numeric vector of the form
\code{west (long), south (lat), east (long), north (lat)}. optional}

\item{fmt}{(integer/numeric) number of digits. Default: 7}
}
\value{
WKT; a character vector with one ore more POINT strings
}
\description{
Random WKT point
}
\examples{
wkt_point()
wkt_point(10)
wkt_point(100)

wkt_point(fmt = 5)
wkt_point(fmt = 6)
wkt_point(fmt = 7)

wkt_point(bbox = c(50, 50, 60, 60))
}
