/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.variables;

import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Variable;
import eu.amidst.dynamic.variables.DynamicAssignment;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapDynamicAssignment
implements DynamicAssignment {
    private Map<Variable, Double> assignment;
    long sequenceID;
    long timeID;

    public HashMapDynamicAssignment(int nOfVars) {
        this.assignment = new ConcurrentHashMap<Variable, Double>(nOfVars);
    }

    @Override
    public double getValue(Variable key) {
        Double val = this.assignment.get(key);
        if (val != null) {
            return val;
        }
        return Utils.missingValue();
    }

    @Override
    public void setValue(Variable var, double val) {
        this.assignment.put(var, val);
    }

    @Override
    public Set<Variable> getVariables() {
        return this.assignment.keySet();
    }

    @Override
    public long getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(int sequenceID) {
        this.sequenceID = sequenceID;
    }

    @Override
    public long getTimeID() {
        return this.timeID;
    }

    public void setTimeID(int timeID) {
        this.timeID = timeID;
    }
}

