/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.models;

import eu.amidst.core.models.DAG;
import eu.amidst.core.models.ParentSet;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.Variables;
import eu.amidst.dynamic.variables.DynamicVariables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DynamicDAG
implements Serializable {
    private static final long serialVersionUID = 123181485615649547L;
    private DynamicVariables dynamicVariables;
    private List<ParentSet> parentSetTime0;
    private List<ParentSet> parentSetTimeT;
    private String name = "DynamicDAG";

    public DynamicDAG(DynamicVariables dynamicVariables1) {
        this.dynamicVariables = dynamicVariables1;
        this.parentSetTime0 = new ArrayList<ParentSet>(this.dynamicVariables.getNumberOfVars());
        this.parentSetTimeT = new ArrayList<ParentSet>(this.dynamicVariables.getNumberOfVars());
        for (Variable var : this.dynamicVariables) {
            this.parentSetTime0.add(var.getVarID(), new ParentSetImpl(var));
            this.parentSetTimeT.add(var.getVarID(), new ParentSetImpl(var));
        }
        this.dynamicVariables.block();
    }

    public void updateDynamicVariables(DynamicVariables dynamicVariables1) {
        this.dynamicVariables = dynamicVariables1;
        this.dynamicVariables.block();
        for (Variable var : this.dynamicVariables) {
            if (var.getVarID() < this.parentSetTime0.size()) continue;
            this.parentSetTime0.add(var.getVarID(), new ParentSetImpl(var));
            this.parentSetTimeT.add(var.getVarID(), new ParentSetImpl(var));
        }
    }

    public DynamicVariables getDynamicVariables() {
        return this.dynamicVariables;
    }

    public ParentSet getParentSetTimeT(Variable var) {
        if (var.isInterfaceVariable()) {
            throw new UnsupportedOperationException("Parents of clone variables can not be queried. Just query the parentsof its dynamic counterpart.");
        }
        return this.parentSetTimeT.get(var.getVarID());
    }

    public ParentSet getParentSetTime0(Variable var) {
        if (var.isInterfaceVariable()) {
            throw new UnsupportedOperationException("Parents of clone variables can not be queried. Just query the parentsof its dynamic counterpart.");
        }
        return this.parentSetTime0.get(var.getVarID());
    }

    public DAG toDAGTimeT() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        allVariables.addAll(this.getDynamicVariables().getListOfDynamicVariables());
        allVariables.addAll(this.getDynamicVariables().getListOfInterfaceVariables());
        Variables staticVariables = Variables.auxiliarBuilder(allVariables);
        DAG dag = new DAG(staticVariables);
        dag.setName(this.getName());
        for (Variable dynamicVariable : this.dynamicVariables) {
            for (Variable parent : this.getParentSetTimeT(dynamicVariable)) {
                dag.getParentSet(dynamicVariable).addParent(parent);
            }
        }
        return dag;
    }

    public DAG toDAGTime0() {
        Variables staticVariables = Variables.auxiliarBuilder(this.getDynamicVariables().getListOfDynamicVariables());
        DAG dag = new DAG(staticVariables);
        dag.setName(this.getName());
        for (Variable dynamicVariable : this.dynamicVariables) {
            for (Variable parent : this.getParentSetTime0(dynamicVariable)) {
                dag.getParentSet(dynamicVariable).addParent(parent);
            }
        }
        return dag;
    }

    public boolean containCycles() {
        return this.toDAGTimeT().containCycles() || this.toDAGTime0().containCycles();
    }

    public List<ParentSet> getParentSetsTimeT() {
        return this.parentSetTimeT;
    }

    public List<ParentSet> getParentSetsTime0() {
        return this.parentSetTime0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nDynamic DAG at Time 0\n");
        for (Variable var : this.getDynamicVariables()) {
            str.append(var.getName() + " has " + this.getParentSetTime0(var).getNumberOfParents() + " parent(s): " + this.parentSetTime0.get(var.getVarID()).toString() + "\n");
        }
        str.append("\nDynamic DAG at Time T\n");
        for (Variable var : this.getDynamicVariables()) {
            str.append(var.getName() + " has " + this.getParentSetTimeT(var).getNumberOfParents() + " parent(s): " + this.getParentSetTimeT(var).toString() + "\n");
        }
        return str.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicDAG dyndag = (DynamicDAG)o;
        int i = 0;
        boolean eqs = true;
        if (this.parentSetTime0.size() != dyndag.getParentSetsTime0().size()) {
            return false;
        }
        while (i < this.parentSetTime0.size() && eqs) {
            if (this.getParentSetsTime0().get(i).equals(dyndag.getParentSetsTime0().get(i))) {
                ++i;
                continue;
            }
            eqs = false;
        }
        if (this.parentSetTimeT.size() != dyndag.getParentSetsTimeT().size()) {
            return false;
        }
        i = 0;
        while (i < this.parentSetTimeT.size() && eqs) {
            if (this.getParentSetsTime0().get(i).equals(dyndag.getParentSetsTime0().get(i))) {
                ++i;
                continue;
            }
            eqs = false;
        }
        return eqs;
    }

    private final class ParentSetImpl
    implements ParentSet,
    Serializable {
        private static final long serialVersionUID = 7416827986614255621L;
        private Variable mainVar;
        private List<Variable> vars;

        private ParentSetImpl(Variable mainVar1) {
            this.mainVar = mainVar1;
            this.vars = new ArrayList<Variable>();
        }

        @Override
        public Variable getMainVar() {
            return this.mainVar;
        }

        @Override
        public void addParent(Variable var) {
            if (!((DistributionType)this.mainVar.getDistributionType()).isParentCompatible(var)) {
                throw new IllegalArgumentException("Adding a parent of type " + var.getDistributionTypeEnum().toString() + " which is not compatible " + "with children variable of type " + this.mainVar.getDistributionTypeEnum().toString());
            }
            if (this.contains(var)) {
                throw new IllegalArgumentException("Trying to add a duplicated parent");
            }
            this.vars.add(var);
            if (!var.isInterfaceVariable() && !((ParentSet)DynamicDAG.this.parentSetTime0.get(this.mainVar.getVarID())).contains(var)) {
                ((ParentSetImpl)((DynamicDAG)DynamicDAG.this).parentSetTime0.get((int)this.mainVar.getVarID())).vars.add(var);
            }
        }

        @Override
        public void removeParent(Variable var) {
            this.vars.remove(var);
        }

        @Override
        public List<Variable> getParents() {
            return this.vars;
        }

        @Override
        public int getNumberOfParents() {
            return this.vars.size();
        }

        @Override
        public String toString() {
            int numParents = this.getNumberOfParents();
            StringBuilder str = new StringBuilder();
            str.append("{");
            for (int i = 0; i < numParents; ++i) {
                Variable parent = this.getParents().get(i);
                str.append(parent.getName());
                if (i >= numParents - 1) continue;
                str.append(", ");
            }
            str.append("}");
            return str.toString();
        }

        @Override
        public void blockParents() {
        }

        @Override
        public boolean contains(Variable var) {
            return this.vars.contains(var);
        }
    }
}

