/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.distributionTypes.IndicatorType;
import java.util.Set;

public interface DataInstance
extends Assignment {
    @Override
    default public double getValue(Variable var) {
        if (var.getAttribute() == null) {
            return Utils.missingValue();
        }
        if (var.isIndicator() && (!Utils.isMissingValue(this.getValue(var.getAttribute())) || Utils.isMissingValue(this.getValue(var.getAttribute())) && ((IndicatorType)var.getDistributionType()).getDeltaValue() != Double.NaN)) {
            return this.getValue(var.getAttribute()) == ((IndicatorType)var.getDistributionType()).getDeltaValue() ? 0.0 : 1.0;
        }
        return this.getValue(var.getAttribute());
    }

    @Override
    default public void setValue(Variable var, double value) {
        if (var.getAttribute() != null) {
            this.setValue(var.getAttribute(), value);
        }
    }

    @Override
    default public Set<Variable> getVariables() {
        return null;
    }

    @Override
    default public String outputString() {
        StringBuilder builder = new StringBuilder(this.getAttributes().getFullListOfAttributes().size() * 2);
        builder.append("{");
        this.getAttributes().getFullListOfAttributes().stream().forEach(att -> builder.append(att.getName() + " = " + att.stringValue(this.getValue((Attribute)att)) + ", "));
        builder.append("}");
        return builder.toString();
    }

    public Attributes getAttributes();

    public double getValue(Attribute var1);

    public void setValue(Attribute var1, double var2);

    public double[] toArray();
}

