% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/term_structures.R
\name{detail_from_AnnivDates}
\alias{detail_from_AnnivDates}
\title{Convert output of BondValuation::AnnivDates to inputd for Bond}
\usage{
detail_from_AnnivDates(anvdates, as_of = Sys.time(),
  normalization_factor = 365.25)
}
\arguments{
\item{anvdates}{Output of BondValuation::AnnivDates(), which must have included a `Coup` argument so that the resulting list contains an entry for `PaySched`}

\item{as_of}{Date or time from whose perspective times should be computed}

\item{normalization_factor}{Factor by which raw R time differences should be multiplied.  If volatilites are going to be annualized, then this should typically be 365 or so.}
}
\value{
A list with some of the arguments appropriate for defining a Bond as follows:
            maturity - maturity
            notional - notional amount
            coupons - `data.frame` with `payment_time`, `payment_size`
}
\description{
The BondValuation package provides day count convention treatments superior
 to quantmod or any other R package known (as of May 2019).  This function
 takes output from BondValuation::AnnivDates(...) and parses it into
 notionals, maturity time, and coupon times and sizes.
}
\details{
Note: volatilities used in `ragtop` must have compatible time units to these times.
}
