% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ragnar_retrieve_vss}
\alias{ragnar_retrieve_vss}
\title{Uses vector similarity search}
\usage{
ragnar_retrieve_vss(
  store,
  text,
  top_k = 3L,
  method = c("cosine_distance", "cosine_similarity", "euclidean_distance", "dot_product",
    "negative_dot_product")
)
}
\arguments{
\item{store}{A \code{RagnarStore} object or a \code{dplyr::tbl()} derived from
it. When you pass a \code{tbl}, you may use usual dplyr verbs (e.g.
\code{filter()}, \code{slice()}) to restrict the rows examined before
similarity scoring. Avoid dropping essential columns such as
\code{text}, \code{embedding}, \code{origin}, and \code{hash}.}

\item{text}{A string to find the nearest match too}

\item{top_k}{Integer, maximum amount of document chunks to retrieve}

\item{method}{A string specifying the method used to compute the similarity
between the query and the document chunks embeddings store in the database.}
}
\value{
A dataframe of retrieved chunks. Each row corresponds to an
individual chunk in the store. It always contains a column named \code{text}
that contains the chunks.
}
\description{
Computes a similarity measure between the query and the documents embeddings
and uses this similarity to rank the documents.
}
\details{
The supported methods are:
\itemize{
\item \strong{cosine_distance}: Measures the dissimilarity between two vectors based on
the cosine of the angle between them. Defined as \eqn{1 - cos(\theta)},
where \eqn{cos(\theta)} is the cosine similarity.
\item \strong{cosine_similarity}: Measures the similarity between two vectors based on
the cosine of the angle between them. Ranges from -1 (opposite) to 1 (identical),
with 0 indicating orthogonality.
\item \strong{euclidean_distance}: Computes the straight-line (L2) distance between
two points in a multidimensional space. Defined as \eqn{\sqrt{\sum(x_i - y_i)^2}}.
\item \strong{dot_product}: Computes the sum of the element-wise products of two vectors.
\item \strong{negative_dot_product}: The negation of the dot product.
}
}
\section{Pre-filtering with dplyr}{

The store behaves like a lazy table backed by DuckDB, so row‑wise
filtering is executed directly in the database. This lets you narrow the
search space efficiently without pulling data into R.
}

\examples{
\dontshow{if ((rlang::is_installed("dbplyr") && nzchar(Sys.getenv("OPENAI_API_KEY")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Basic usage
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small")
)
ragnar_store_insert(store, data.frame(text = c("foo", "bar")))
ragnar_store_build_index(store)
ragnar_retrieve(store, "foo")

# More Advanced: store metadata, retrieve with pre-filtering
store <- ragnar_store_create(
  embed = \(x) ragnar::embed_openai(x, model = "text-embedding-3-small"),
  extra_cols = data.frame(category = character())
)

ragnar_store_insert(
  store,
  data.frame(
    category = "desert",
    text = c("ice cream", "cake", "cookies")
  )
)

ragnar_store_insert(
  store,
  data.frame(
    category = "meal",
    text = c("steak", "potatoes", "salad")
  )
)

ragnar_store_build_index(store)

# simple retrieve
ragnar_retrieve(store, "carbs")

# retrieve with pre-filtering
dplyr::tbl(store) |>
  dplyr::filter(category == "meal") |>
  ragnar_retrieve("carbs")
\dontshow{\}) # examplesIf}
}
\seealso{
Other ragnar_retrieve: 
\code{\link{ragnar_retrieve}()},
\code{\link{ragnar_retrieve_bm25}()},
\code{\link{ragnar_retrieve_vss_and_bm25}()}
}
\concept{ragnar_retrieve}
