% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-html.R
\name{ragnar_find_links}
\alias{ragnar_find_links}
\title{Find links on a page}
\usage{
ragnar_find_links(
  x,
  depth = 0L,
  children_only = TRUE,
  progress = TRUE,
  ...,
  url_filter = identity
)
}
\arguments{
\item{x}{URL, HTML file path, or XML document. For Markdown, convert to HTML
using \code{\link[commonmark:commonmark]{commonmark::markdown_html()}} first.}

\item{depth}{Integer specifying how many levels deep to crawl for links. When
\code{depth > 0}, the function will follow child links (links with \code{x} as a
prefix) and collect links from those pages as well.}

\item{children_only}{Logical or string. If \code{TRUE}, returns only child links
(those having \code{x} as a prefix). If \code{FALSE}, returns all links found on the
page. Note that regardless of this setting, only child links are followed
when \code{depth > 0}.}

\item{progress}{Logical, draw a progress bar if \code{depth > 0}. A separate
progress bar is drawn per recursion level.}

\item{...}{Currently unused. Must be empty.}

\item{url_filter}{A function that takes a character vector of URL's and may
subset them to return a smaller list. This can be useful for filtering out
URL's by rules different them \code{children_only} which only checks the prefix.}
}
\value{
A character vector of links on the page.
}
\description{
Find links on a page
}
\examples{
\dontrun{
ragnar_find_links("https://r4ds.hadley.nz/base-R.html")
ragnar_find_links("https://ellmer.tidyverse.org/")
ragnar_find_links("https://ellmer.tidyverse.org/", depth = 2)
ragnar_find_links("https://ellmer.tidyverse.org/", depth = 2, children_only = FALSE)
ragnar_find_links(
  paste0("https://github.com/Snowflake-Labs/sfquickstarts/",
         "tree/master/site/sfguides/src/build_a_custom_model_for_anomaly_detection"),
  children_only = "https://github.com/Snowflake-Labs/sfquickstarts",
  depth = 1
)
}
}
