% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed-bedrock.R
\name{embed_bedrock}
\alias{embed_bedrock}
\title{Embed text using a Bedrock model}
\usage{
embed_bedrock(x, model, profile, api_args = list())
}
\arguments{
\item{x}{x can be:
\itemize{
\item A character vector, in which case a matrix of embeddings is returned.
\item A data frame with a column named \code{text}, in which case the dataframe is
returned with an additional column named \code{embedding}.
\item Missing or \code{NULL}, in which case a function is returned that can be called
to get embeddings. This is a convenient way to partial in additional arguments like \code{model},
and is the most convenient way to produce a function that can be passed to the \code{embed} argument of \code{ragnar_store_create()}.
}}

\item{model}{Currently only Cohere.ai and Amazon Titan models are supported.
There are no guardarails for the kind of model that is used, but the model
must be available in the AWS region specified by the profile.
You may look for available models in the Bedrock Model Catalog}

\item{profile}{AWS profile to use.}

\item{api_args}{Additional arguments to pass to the Bedrock API. Dependending
on the \code{model}, you might be able to provide different parameters. Check
the documentation for the model you are using in the
\href{https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html}{Bedrock user guide}.}
}
\value{
If \code{x} is missing returns a function that can be called to get embeddings.
If \code{x} is not missing, a matrix of embeddings with 1 row per input string, or a dataframe with an 'embedding' column.
}
\description{
Embed text using a Bedrock model
}
\seealso{
\code{\link[=embed_ollama]{embed_ollama()}}
}
