% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_png}
\alias{agg_png}
\title{Draw to a PNG file}
\usage{
agg_png(
  filename = "Rplot\%03d.png",
  width = 480,
  height = 480,
  units = "px",
  pointsize = 12,
  background = "white",
  res = 72,
  bitsize = 8
)
}
\arguments{
\item{filename}{The name of the file. Follows the same semantics as the file 
naming in [grDevices::png()], meaning that you can provide a [sprintf()] 
compliant string format to name multiple plots (such as the default value)}

\item{width}{The dimensions of the device}

\item{height}{The dimensions of the device}

\item{units}{The unit `width` and `height` is measured in, in either pixels 
(`'px'`), inches (`'in'`), millimeters (`'mm'`), or centimeter (`'cm'`).}

\item{pointsize}{The default pointsize of the device in pt}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{bitsize}{Should the device record colour as 8 or 16bit}
}
\description{
The PNG (Portable Network Graphic) format is one of the most ubiquitous 
today, due to its versatiliity 
and widespread support. It supports transparancy as well as both 8 and 16 bit
colour. The device uses default compression and filtering and will not use a
colour palette as this is less useful for antialiased data. This means that 
it might be possible to compress the resulting image even more if size is of
concern (though the defaults are often very good). In contrast to 
[grDevices::png()] the date and time will not be written to the file, meaning
that similar plot code will produce identical files (a good feature if used 
with version control). It will, however, write in the dimensions of the image
based on the `res` argument.
}
\examples{
file <- tempfile(fileext = '.png')
agg_png(file)
plot(sin, -pi, 2*pi)
dev.off()

}
