% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/air_dens_cf.R
\name{air_dens_cf}
\alias{air_dens_cf}
\title{Correct for air density - useful for vented ion chambers}
\usage{
air_dens_cf(T.actual, P.actual, T.ref = 20, P.ref = 760)
}
\arguments{
\item{T.actual}{The actual air temperature, in Celsius}

\item{P.actual}{The actual air pressure, in mm Hg}

\item{T.ref}{The reference air temperature - default is 20C}

\item{P.ref}{The reference air pressure - default is 760 mm Hg}
}
\value{
The ratio of actual to reference air density.
}
\description{
Obtain a correction factor for ion chamber temperature and
  pressure vs reference calibration values.
}
\examples{
air_dens_cf(T.actual = 20, P.actual = 760, T.ref = 20, P.ref = 760)
air_dens_cf(30, 750)
}
\seealso{
Other rad measurements: 
\code{\link{disk_to_disk_solid_angle}()},
\code{\link{neutron_geom_cf}()},
\code{\link{scaler_sim}()},
\code{\link{tau_estimate}()}
}
\concept{rad measurements}
