% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImageQuantize.R
\name{discretizeImage}
\alias{discretizeImage}
\title{Image Discretization.}
\usage{
discretizeImage(data, n_grey = 32, verbose = TRUE)
}
\arguments{
\item{data}{A numeric 2D matrix.}

\item{n_grey}{an integer value, the number of grey levels the image should
be quantized into.}

\item{verbose}{Logical, a message is given when the user 
supplies more grey values than exist in the image. Setting this value to FALSE
will suppress this message.}
}
\value{
A matrix of the same dimensions as the input matrix. The entries of the matrix
 will be set to begin at 1, and go up to the specified value. There is no guarantee
 that each gray level between 1 and n_grey will have pixels of that value (for example, 
 although n_grey = 32 may be specified, certain images may contain fewer than 32 grey levels).
}
\description{
\code{discretizeImage} Scales the grey values of an image into a specified number of values.
}
\details{
This function is called in \code{glcm}, \code{glrlm}, \code{glszm}, and \code{mglszm}.

If n_grey is greater than the number of unique grey levels in the matrix then no action
is taken.
}
\examples{
image(psf)
image(discretizeImage(psf, n_grey=5, verbose=F))

image(tumor)
image(discretizeImage(tumor, n_grey=8, verbose=F))
}

