% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore.R
\name{explore}
\alias{explore}
\title{Explore data}
\usage{
explore(dataset, vars = "", byvar = "", fun = c("mean_rm", "sd_rm"),
  top = "fun", tabfilt = "", tabsort = "", nr = NULL,
  data_filter = "", shiny = FALSE)
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{vars}{(Numerical) variables to summaries}

\item{byvar}{Variable(s) to group data by before summarizing}

\item{fun}{Functions to use for summarizing}

\item{top}{The variable (type) to display at the top of the table}

\item{tabfilt}{Expression used to filter the table. This should be a string (e.g., "Total > 10000")}

\item{tabsort}{Expression used to sort the table (e.g., "-Total")}

\item{nr}{Number of rows to display}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{shiny}{Logical (TRUE, FALSE) to indicate if the function call originate inside a shiny app}
}
\value{
A list of all variables defined in the function as an object of class explore
}
\description{
Explore data
}
\details{
See \url{http://radiant-rstats.github.io/docs/data/explore.html} for an example in Radiant
}
\examples{
result <- explore("diamonds", "price:x")
summary(result)
result <- explore("diamonds", c("price","carat"), byvar = "cut", fun = c("n_missing", "skew"))
summary(result)
diamonds \%>\% explore("price", byvar = "cut", fun = c("length", "n_distinct"))

}
\seealso{
\code{\link{summary.explore}} to show summaries
}

