% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wind_functions.R
\name{flow.dispersion}
\alias{flow.dispersion}
\title{Compute flow-based cost or conductance}
\usage{
flow.dispersion(dl, sl, type = "passive", output = "raw")
}
\arguments{
\item{dl}{Direction layer. Raster layer obtained from wind2raster function
("rWind" package) with flow direction values.}

\item{sl}{Speed layer. Raster layer obtained from wind2raster function
("rWind" package) with flow speed values.}

\item{type}{Could be either "passive" or "active".In "passive" mode,
movement against flow direction is not allowed (deviations from the wind
direction higher than 90). In "active" mode, the movement can go against flow
direction, by increasing the cost.}

\item{output}{This argument allows to select diferent kinds of output. "raw"
mode creates a matrix (class "dgCMatrix") with transition costs between all
cells in the raster. "transitionLayer" creates a TransitionLayer object with
conductance values to be used with "gdistance" package.}
}
\value{
In "transitionLayer" output, the function returns conductance values
(1/cost)to move betwen all cells in a raster having into account flow speed
and direction obtained from wind.fit function("rWind" package). As wind or
sea currents implies directionality, flow.dispersion produces an anisotropic
conductance matrix (asimetric). Conductance values are used later to built a
TransitionLayer object from "gdistance" package.

In "raw" output, flow.dispersion creates a sparse Matrix with cost values.
}
\description{
flow.dispersion computes movement conductance through a flow either, sea or
wind currents. It implements the formula described in Felícisimo et al.
2008:
}
\details{
Cost=(1/Speed)*(HorizontalFactor)

being HorizontalFactor a "function that incrementaly penalized angular
deviations from the wind direction" (Felicísimo et al. 2008).
}
\note{
Note that for large data sets, it could take a while. For large study
areas is strongly adviced perform the analysis in a remote computer or a
cluster.
}
\examples{

 require(gdistance)

 w<-wind.dl(2015,2,12,0,-10,5,35,45)

 data(wind_data)
 w<-wind.fit(wind_data)

 dl<-wind2raster(w)
 sl<-wind2raster(w, type="speed")

 Conductance<-flow.dispersion(dl,sl,"passive", "transitionLayer")

# transitionMatrix(Conductance)
# image(transitionMatrix(Conductance))

}
\references{
Felicísimo, Á. M., Muñoz, J., & González-Solis, J. (2008). Ocean surface
winds drive dynamics of transoceanic aerial movements. PLoS One, 3(8),
e2928.

Jacob van Etten (2017). R Package gdistance: Distances and Routes on
Geographical Grids. Journal of Statistical Software, 76(13), 1-21.
doi:10.18637/jss.v076.i13
}
\seealso{
\code{\link{wind.fit}}, \code{\link{wind2raster}}
}
\author{
Javier Fernández-López; Klaus Schliep
}
\keyword{~anisotropy}
\keyword{~conductance}
