% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_occ_mat.r
\name{wcvp_occ_mat}
\alias{wcvp_occ_mat}
\title{Generate occurrence matrix for taxa and areas}
\usage{
wcvp_occ_mat(
  taxon = NULL,
  taxon_rank = c("species", "genus", "family", "order", "higher"),
  area_codes = NULL,
  native = TRUE,
  introduced = TRUE,
  extinct = TRUE,
  location_doubtful = TRUE,
  wcvp_names = NULL,
  wcvp_distributions = NULL
)
}
\arguments{
\item{taxon}{Character. One or many taxa to be included. Defaults to NULL (all species)}

\item{taxon_rank}{Character. One of "species", "genus", "family", "order" or "higher", giving the rank of the value/s in \code{taxon}. Must be specified unless taxon is \code{NULL}.}

\item{area_codes}{Character. One or many WGSPRD level 3 region codes. Defaults to \code{NULL} (global).}

\item{native}{Logical. Include species occurrences not flagged as introduced, extinct or doubtful? Defaults to TRUE.}

\item{introduced}{Logical. Include species occurrences flagged as introduced? Defaults to TRUE.}

\item{extinct}{Logical. Include species occurrences flagged as extinct? Defaults to TRUE.}

\item{location_doubtful}{Logical. Include species occurrences flagged as location doubtful? Defaults to TRUE.}

\item{wcvp_names}{A data frame of taxonomic names from WCVP version 7 or later.
If \code{NULL}, names will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{rWCVPdata::wcvp_names}.}

\item{wcvp_distributions}{A data frame of distributions from WCVP version 7 or later.
If \code{NULL}, distributions will be loaded from \href{https://matildabrown.github.io/rWCVPdata/}{rWCVPdata::wcvp_names}.}
}
\value{
A data.frame containing the \code{taxon_name} and \code{plant_name_id}
of all species that are present in the \code{area}, plus one variable for each WGSPRD level 3 region in \code{area}, with species presences marked as 1 and absences marked as 0.
}
\description{
Generate occurrence matrix for taxa and areas
}
\details{
See \href{https://matildabrown.github.io/rWCVP/articles/occurrence-matrices.html}{here} for an example of how this output can be formatted for publication.
}
\examples{
\donttest{ # this example requires 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
wcvp_occ_mat(
  taxon = "Poa", taxon_rank = "genus",
  area = c("TAS", "VIC", "NSW"), introduced = FALSE
)
}
}

}
