% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcvp_distribution_map.R
\name{wcvp_distribution_map}
\alias{wcvp_distribution_map}
\title{Plot distribution maps for species, genera or families}
\usage{
wcvp_distribution_map(
  range,
  crop_map = FALSE,
  native = TRUE,
  introduced = TRUE,
  extinct = TRUE,
  location_doubtful = TRUE
)
}
\arguments{
\item{range}{Simple features (\code{sf}) data frame of the type output by \code{\link[=wcvp_distribution]{wcvp_distribution()}}.}

\item{crop_map}{Logical. Crop map extent to distribution? Defaults to \code{FALSE}.}

\item{native}{Logical. Include native range? Defaults to \code{TRUE}.}

\item{introduced}{Logical. Include introduced range? Defaults to \code{TRUE}.}

\item{extinct}{Logical. Include extinct range? Defaults to \code{TRUE}.}

\item{location_doubtful}{Logical. Include occurrences that are thought to be
doubtful? Defaults to \code{TRUE}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot}} of the distribution.
}
\description{
Plot distribution maps for species, genera or families
}
\details{
The colour scheme mirrors that used by Plants of the World (POWO;
https://powo.science.kew.org/), where green is native, purple is introduced, red is extinct and orange is doubtful. See Examples for how to use custom colours.
}
\examples{
\donttest{ # these examples require 'rWCVPdata'
if(requireNamespace("rWCVPdata")){
p <- wcvp_distribution_map(wcvp_distribution("Callitris", taxon_rank = "genus"))
p
# now only the native range, and cropped to range extent
p <- wcvp_distribution_map(wcvp_distribution("Callitris", taxon_rank = "genus"),
  introduced = FALSE, crop_map = TRUE
)
p
# now with different colours
# note that this taxon only has native and introduced occurrences, so only two colours are needed
p <- wcvp_distribution_map(wcvp_distribution("Callitris", taxon_rank = "genus"))
p +
  # for polygons
  ggplot2::scale_fill_manual(values = c("red", "blue")) +
  # for points (islands)
  ggplot2::scale_colour_manual(values = c("red", "blue"))
  }
  }

}
