% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsm_summary.R
\name{qsm_summary}
\alias{qsm_summary}
\title{QSM Summary}
\usage{
qsm_summary(cylinder, radius, triangulation = NULL)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{radius}{Radius column name either quoted or unquoted.}

\item{triangulation}{QSM triangulation list. Defaults to NULL. Only supports TreeQSM.}
}
\value{
Returns a list
}
\description{
Generates a simple QSM summary (e.g. volume, surface area, dbh, etc.) by totals and branch order.
}
\examples{

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)
qsm_summary(cylinder, radius)

# TreeQSM Triangulation
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)
qsm_summary(cylinder, radius, triangulation = qsm$triangulation)

}
