% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/XPSgrowth.R
\name{XPSgrowth}
\alias{XPSgrowth}
\title{XPSgrowth}
\usage{
XPSgrowth(
  data_trees,
  parameters = NULL,
  search_initial_gom = FALSE,
  search_initial_double_gom = FALSE,
  fitting_method = c("gompertz", "GAM", "brnn"),
  ID_vars = NULL,
  fitted_save = FALSE,
  add_zeros = TRUE,
  add_zeros_before = "min",
  post_process = TRUE,
  unified_parameters = FALSE,
  gom_a = NA,
  gom_b = NA,
  gom_k = NA,
  d_gom_a1 = NA,
  d_gom_a2 = NA,
  d_gom_b1 = NA,
  d_gom_b2 = NA,
  d_gom_k1 = NA,
  d_gom_k2 = NA,
  brnn_neurons = NA,
  gam_k = NA,
  gam_sp = NA,
  gom_a_range = seq(0, 3000, by = 500),
  gom_b_range = seq(0.01, 1000, by = 50),
  gom_k_range = seq(0, 500, by = 2),
  d_gom_a1_range = seq(0, 1, by = 0.001),
  d_gom_a2_range = seq(0, 5, by = 0.01),
  d_gom_b1_range = seq(0, 5, by = 0.001),
  d_gom_b2_range = seq(0, 10, by = 0.1),
  d_gom_k1_range = seq(0, 1, by = 0.001),
  d_gom_k2_range = seq(0, 1, by = 0.001)
)
}
\arguments{
\item{data_trees}{a data frame with ID variables and wood formation data with
columns doy and width}

\item{parameters}{a data frame with ID variables and initial parameter values
for the selected methods}

\item{search_initial_gom}{logical, should the algorithm to search initial
Gompertz parameters be applied? This argument also overwrites manually
defined Gompertz parameter values}

\item{search_initial_double_gom}{logical, should the algorithm to search
initial parameters for double Gompertz function be applied? This argument
also overwrites manually defined parameter values for double Gompertz}

\item{fitting_method}{vector of one or more methods to be compared:
"gompertz", "double_gompertz", "gam", "brnn"}

\item{ID_vars}{character vector of variables which indicate column names of
ID variables}

\item{fitted_save}{logical, should the fitted curves be saved in current
working directory?}

\item{add_zeros}{logical, should zero observations at the beginning of
growing season be added?}

\item{add_zeros_before}{if 'min' (character) then zeros will be added prior
to the first observation in each year. Alternatively, users can specify
absolute doy prior which zeros will be added.}

\item{post_process}{logical, should the post-process algorithm be applied?}

\item{unified_parameters}{logical, if TRUE, the algorithm will use only
manually selected function parameters. See the arguments 'gom_a', 'gom_b',
'd_gom_k', 'd_gom_a1', 'd_gom_a2', 'd_gom_b1', 'd_gom_b2', 'd_gom_k1',
'd_gom_k2', 'brnn_neurons', 'gam_k' and 'gam_sp'. Default is FALSE}

\item{gom_a}{numeric, the parameter a for the Gompertz function}

\item{gom_b}{numeric, the parameter b for the Gompertz function}

\item{gom_k}{numeric, the parameter k for the Gompertz function}

\item{d_gom_a1}{numeric, the parameter a1 for the double Gompertz function}

\item{d_gom_a2}{numeric, the parameter a2 for the double Gompertz function}

\item{d_gom_b1}{numeric, the parameter b1 for the double Gompertz function}

\item{d_gom_b2}{numeric, the parameter b2 for the double Gompertz function}

\item{d_gom_k1}{numeric, the parameter k1 for the double Gompertz function}

\item{d_gom_k2}{numeric, the parameter k2 for the double Gompertz function}

\item{brnn_neurons}{positive integer, the number of neurons to be used by
the BRNN method}

\item{gam_k}{numeric, the parameter k for General Additive Model (GAM)}

\item{gam_sp}{numeric, the parameter sp for General Additive Model (GAM)}

\item{gom_a_range}{a numerical vector of the possible values of the
parameter a, which is considered in the search for the initial Gompertz
parameter values}

\item{gom_b_range}{a numerical vector of the possible values of the
parameter b, which is considered in the search for the initial Gompertz
parameter values}

\item{gom_k_range}{a numerical vector of the possible values of the
parameter k, which is considered in the search for the initial Gompertz
parameter values}

\item{d_gom_a1_range}{A numerical vector representing the range of potential
values for the 'a1' parameter within the double Gompertz function.}

\item{d_gom_a2_range}{A numerical vector representing the range of potential
values for the 'a2' parameter within the double Gompertz function.}

\item{d_gom_b1_range}{A numerical vector representing the range of potential
values for the 'b1' parameter within the double Gompertz function.}

\item{d_gom_b2_range}{A numerical vector representing the range of potential
values for the 'b2' parameter within the double Gompertz function.}

\item{d_gom_k1_range}{A numerical vector representing the range of potential
values for the 'k1' parameter within the double Gompertz function.}

\item{d_gom_k2_range}{A numerical vector representing the range of potential
values for the 'k2' parameter within the double Gompertz function.}
}
\value{
a list with the following elements:
\enumerate{
 \item $fitted - a data frame with fitted values
 \item $gompertz_initial_parameters - a data frame that contains a curated selection of initial parameter values for the Gompertz function.
 \item $gompertz_model_parameters - a data frame with final model coefficients for the Gompertz function.
 \item $gompertz_initial_parameters_errors - a data frame with unsuccessful cases of Gompertz grid search.
 \item $double_gompertz_initial_parameters - a data frame that contains a curated selection of initial parameter values for the double Gompertz function.
 \item $double_gompertz_initial_parameters_errors - a data frame with unsuccessful cases of double Gompertz grid search.
 \item $doble_gompertz_model_parameters - a data frame with final model coefficients for the double Gompertz function.
}
}
\description{
XylemPhloemSeasonalGrowth: This Function fits and compares the selected
methods for modeling seasonal xylem and phloem data.
}
\examples{
library(rTG)

# 1 Example on xylem and phloem data
data(parameters)
data(data_trees)

# subset data_trees
data_trees <- data_trees[c(1:27),]

# 1a Example using neural network
simulation_1a <- XPSgrowth(data_trees = data_trees,
     parameters = parameters,
     ID_vars = c("Species", "Tissue", "Site", "Year", "Tree"),
     fitting_method = c("brnn"),
     fitted_save = FALSE,
     search_initial_gom = FALSE,
     add_zeros = TRUE,
     add_zeros_before = 'min',
     post_process = TRUE)

\dontrun{
#' # 1b Example on double Gompertz function
simulation_1b <- XPSgrowth(data_trees = data_trees,
     parameters = parameters,
     ID_vars = c("Species", "Tissue", "Site", "Year"),
     fitting_method = c("double_gompertz"),
     fitted_save = FALSE,
     search_initial_double_gom = FALSE,
     unified_parameters = TRUE,
     add_zeros = TRUE,
     add_zeros_before = 'min',
     d_gom_a1 = 0.204, d_gom_a2 = 0.240,
     d_gom_b1 = 2.433, d_gom_b2 = 2.900,
     d_gom_k1 = 0.974, d_gom_k2 = 0.963,
     post_process = TRUE)

# 1b Example on Double Gompertz function without initial parameters
simulation_1c <- XPSgrowth(data_trees = data_trees,
     parameters = parameters,
     ID_vars = c("Species", "Tissue", "Site", "Year"),
     fitting_method = c("double_gompertz"),
     fitted_save = FALSE,
     search_initial_double_gom = TRUE,
     post_process = TRUE)

# Obtain model parameters
simulation_1c$double_gompertz_model_parameters
}

# 2 Example on dendrometer data
data("data_dendrometers")

simulation_2 <- XPSgrowth(data_dendrometers, unified_parameters = TRUE,
                  ID_vars = c("site", "species", "year", "tree"),
                  fitting_method = c("brnn", "gam"),
                  brnn_neurons = 2, gam_k = 9, gam_sp = 0.5,
                  search_initial_gom = TRUE, add_zeros = FALSE,
                  post_process = TRUE)
}
