/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import org.python.core.Py;
import org.python.core.io.SocketIOBase;

public class SocketIO
extends SocketIOBase {
    private SocketChannel socketChannel;

    public SocketIO(SocketChannel socketChannel, String mode) {
        super(mode);
        this.socketChannel = socketChannel;
    }

    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.socketChannel.read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            return this.socketChannel.read(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.socketChannel.write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return this.socketChannel.write(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    public Channel getChannel() {
        return this.socketChannel;
    }
}

