% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_verbs.R
\name{mutate.actframe}
\alias{mutate.actframe}
\title{Mutate}
\usage{
\method{mutate}{actframe}(.data, ...)
}
\arguments{
\item{.data}{an actframe object}

\item{...}{Name-value pairs of expressions. Use NULL to drop a variable.}
}
\value{
an actframe object
}
\description{
This is a wrapper function to dplyr::mutate which can be applied to an actframe object
}
\examples{
\dontrun{
library(dplyr)

# get actframe, all activities
stoken <- httr::config(
  token = strava_oauth(
    app_name, 
    app_client_id, 
    app_secret, 
    app_scope="activity:read_all"
  )
)
my_acts <- get_activity_list(stoken)
act_data <- compile_activities(my_acts)

# mutate
act_data \%>\% mutate(is_run=type=='Run')
}
}
